/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.DoubleGenericTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class MapIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapIntrospector.class);
    private static final Matcher MATCHER = new AssignableTypeMatcher(Map.class);

    @Override
    public boolean match(Property property) {
        return DoubleGenericTypeMatcher.DOUBLE_GENERIC_TYPE_MATCHER.match(property) && MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty arbitraryProperty = context.getArbitraryProperty();
        if (!arbitraryProperty.isContainer() || !this.match(context.getResolvedProperty())) {
            LOGGER.info("Given type {} is not Map type.", (Object)context.getResolvedType());
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        List<CombinableArbitrary<?>> elementCombinableArbitraryList = context.getElementCombinableArbitraryList();
        return new ArbitraryIntrospectorResult(CombinableArbitrary.containerBuilder().elements(elementCombinableArbitraryList).build(MapIntrospector.combine(context)));
    }

    private static Function<List<Object>, Object> combine(ArbitraryGeneratorContext context) {
        return elements -> {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (Object element : elements) {
                MapEntryElementProperty.MapEntryElementType mapEntryElement = (MapEntryElementProperty.MapEntryElementType)element;
                if (mapEntryElement.getKey() == null) {
                    throw new IllegalArgumentException("Map key cannot be null.");
                }
                map.put(mapEntryElement.getKey(), mapEntryElement.getValue());
            }
            context.evictUnique(context.getPropertyPath());
            return map;
        };
    }
}

