/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.CandidateConcretePropertyResolver;
import com.navercorp.fixturemonkey.api.property.ConcreteTypeProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyUtils;
import com.navercorp.fixturemonkey.api.type.GenericType;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="1.0.16", status=API.Status.EXPERIMENTAL)
public final class ConcreteTypeCandidateConcretePropertyResolver<T>
implements CandidateConcretePropertyResolver {
    private final List<Class<? extends T>> concreteTypes;

    public ConcreteTypeCandidateConcretePropertyResolver(List<Class<? extends T>> concreteTypes) {
        this.concreteTypes = concreteTypes;
    }

    @Override
    public List<Property> resolve(final Property property) {
        List<AnnotatedType> genericsTypes = Types.getGenericsTypes(property.getAnnotatedType());
        if (!genericsTypes.isEmpty()) {
            Type[] typeArguments = (Type[])genericsTypes.stream().map(AnnotatedType::getType).toArray(Type[]::new);
            return this.concreteTypes.stream().map(it -> {
                final GenericType concreteGenericType = new GenericType((Type)it, typeArguments, null);
                AnnotatedType genericAnnotatedType = new AnnotatedType(){

                    @Override
                    public Type getType() {
                        return concreteGenericType;
                    }

                    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
                        return (A)((Annotation)property.getAnnotation(annotationClass).orElse(null));
                    }

                    @Override
                    public Annotation[] getAnnotations() {
                        return property.getAnnotations().toArray(new Annotation[0]);
                    }

                    @Override
                    public Annotation[] getDeclaredAnnotations() {
                        return property.getAnnotations().toArray(new Annotation[0]);
                    }
                };
                return new ConcreteTypeProperty(genericAnnotatedType, property);
            }).collect(Collectors.toList());
        }
        return this.concreteTypes.stream().map(PropertyUtils::toProperty).collect(Collectors.toList());
    }
}

