/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.random;

import com.navercorp.fixturemonkey.api.engine.EngineUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Random;
import net.jqwik.engine.SourceOfRandomness;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.INTERNAL)
@SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"})
public abstract class Randoms {
    private static final ThreadLocal<Random> CURRENT;
    private static final ThreadLocal<Long> SEED;

    @Deprecated
    public static Random create(String seed) {
        Randoms.setSeed(Long.parseLong(seed));
        return CURRENT.get();
    }

    public static void setSeed(long seed) {
        SEED.set(seed);
    }

    public static Random newGlobalSeed(long seed) {
        Randoms.initializeGlobalSeed(seed);
        return CURRENT.get();
    }

    public static Random current() {
        return EngineUtils.useJqwikEngine() ? SourceOfRandomness.current() : CURRENT.get();
    }

    public static long currentSeed() {
        return SEED.get();
    }

    public static int nextInt(int bound) {
        return Randoms.current().nextInt(bound);
    }

    private static void initializeGlobalSeed(long seed) {
        try {
            Random random = Randoms.newRandom(seed);
            CURRENT.set(random);
            SEED.set(seed);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(String.format("[%s] is not a valid random seed.", seed));
        }
    }

    private static Random newRandom(long seed) {
        return EngineUtils.useJqwikEngine() ? SourceOfRandomness.create((String)String.valueOf(seed)) : new XorShiftRandom(seed);
    }

    static {
        SEED = ThreadLocal.withInitial(System::nanoTime);
        CURRENT = ThreadLocal.withInitial(() -> Randoms.newGlobalSeed(SEED.get()));
    }

    private static class XorShiftRandom
    extends Random {
        private long seed;

        private XorShiftRandom(long seed) {
            if (seed == 0L) {
                throw new IllegalArgumentException("0L is not an allowed seed value");
            }
            this.seed = seed;
        }

        @Override
        protected int next(int nbits) {
            long value = this.nextLong();
            return (int)(value &= (1L << nbits) - 1L);
        }

        @Override
        public long nextLong() {
            long value = this.seed;
            value ^= value << 21;
            value ^= value >>> 35;
            value ^= value << 4;
            this.seed = value;
            return value;
        }
    }
}

