/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.tree;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.property.CompositeTypeDefinition;
import com.navercorp.fixturemonkey.api.property.DefaultTypeDefinition;
import com.navercorp.fixturemonkey.api.property.ElementPropertyGenerator;
import com.navercorp.fixturemonkey.api.property.LazyPropertyGenerator;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import com.navercorp.fixturemonkey.api.property.PropertyPath;
import com.navercorp.fixturemonkey.api.property.TreeRootProperty;
import com.navercorp.fixturemonkey.api.property.TypeDefinition;
import com.navercorp.fixturemonkey.api.tree.NodeList;
import com.navercorp.fixturemonkey.api.tree.TraverseContext;
import com.navercorp.fixturemonkey.api.tree.TraverseNode;
import com.navercorp.fixturemonkey.api.tree.TraverseNodeList;
import com.navercorp.fixturemonkey.api.tree.TraverseNodeMetadata;
import com.navercorp.fixturemonkey.api.tree.TreeNodeManipulator;
import com.navercorp.fixturemonkey.api.tree.TreeProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="1.1.4", status=API.Status.EXPERIMENTAL)
public final class DefaultTraverseNode
implements TraverseNode,
TraverseNodeMetadata {
    private final TreeRootProperty rootProperty;
    @Nullable
    private final Property resolvedParentProperty;
    private TypeDefinition resolvedTypeDefinition;
    private final TreeProperty treeProperty;
    private final TraverseContext traverseContext;
    @Nullable
    private TraverseNode parent = null;
    private List<TraverseNode> children;
    @Nullable
    private TypeDefinition expandedTypeDefinition = null;
    private double nullInject;
    private final List<TreeNodeManipulator> containerInfoManipulators = new ArrayList<TreeNodeManipulator>();
    private final LazyArbitrary<PropertyPath> lazyPropertyPath = LazyArbitrary.lazy(() -> {
        Property resolvedProperty = this.resolvedTypeDefinition.getResolvedProperty();
        if (this.parent == null) {
            return new PropertyPath(resolvedProperty, null, 1);
        }
        PropertyPath parentPropertyPath = this.parent.getMetadata().getLazyPropertyPath().getValue();
        return new PropertyPath(resolvedProperty, parentPropertyPath, parentPropertyPath.getDepth() + 1);
    });

    DefaultTraverseNode(TreeRootProperty rootProperty, @Nullable Property resolvedParentProperty, TypeDefinition resolvedTypeDefinition, TreeProperty treeProperty, double nullInject, TraverseContext traverseContext) {
        this.rootProperty = rootProperty;
        this.resolvedParentProperty = resolvedParentProperty;
        this.resolvedTypeDefinition = resolvedTypeDefinition;
        this.treeProperty = treeProperty;
        this.nullInject = nullInject;
        this.traverseContext = traverseContext;
    }

    @Override
    @Nullable
    public Property getResolvedParentProperty() {
        return this.resolvedParentProperty;
    }

    public Property getResolvedProperty() {
        return this.resolvedTypeDefinition.getResolvedProperty();
    }

    @Override
    public TypeDefinition getResolvedTypeDefinition() {
        return this.resolvedTypeDefinition;
    }

    @Override
    public void setResolvedTypeDefinition(TypeDefinition typeDefinition) {
        this.resolvedTypeDefinition = typeDefinition;
    }

    @Override
    public TreeProperty getTreeProperty() {
        return this.treeProperty;
    }

    @Override
    public Property getOriginalProperty() {
        return this.getTreeProperty().getObjectProperty().getProperty();
    }

    @Override
    @Nullable
    public NodeList getChildren() {
        if (this.children == null) {
            return null;
        }
        return new TraverseNodeList(this.children);
    }

    public void setMergedChildren(List<TraverseNode> children) {
        this.children = this.mergeWithNewChildren(children);
        for (TraverseNode child : this.children) {
            DefaultTraverseNode defaultTraverseNode = (DefaultTraverseNode)child;
            defaultTraverseNode.parent = this;
        }
    }

    public ArbitraryProperty getArbitraryProperty() {
        return this.treeProperty.toArbitraryProperty(this.nullInject);
    }

    @Override
    public double getNullInject() {
        return this.nullInject;
    }

    @Override
    public void setNullInject(double nullInject) {
        this.nullInject = nullInject;
    }

    @Override
    @Nullable
    public TraverseNode getParent() {
        return this.parent;
    }

    @Override
    public TreeRootProperty getRootProperty() {
        return this.rootProperty;
    }

    @Override
    public boolean manipulated() {
        return !this.containerInfoManipulators.isEmpty();
    }

    @Override
    public List<TreeNodeManipulator> getTreeNodeManipulators() {
        return this.containerInfoManipulators;
    }

    @Override
    public void addTreeNodeManipulator(TreeNodeManipulator treeNodeManipulator) {
        this.addContainerManipulator(treeNodeManipulator);
    }

    @Override
    @Nullable
    public TreeNodeManipulator getAppliedTreeNodeManipulator() {
        if (this.containerInfoManipulators.isEmpty()) {
            return null;
        }
        return this.containerInfoManipulators.get(this.containerInfoManipulators.size() - 1);
    }

    public void addContainerManipulator(TreeNodeManipulator containerInfoManipulator) {
        this.traverseContext.addContainerInfoManipulator(containerInfoManipulator);
        this.containerInfoManipulators.add(containerInfoManipulator);
    }

    @Override
    public LazyArbitrary<PropertyPath> getLazyPropertyPath() {
        return this.lazyPropertyPath;
    }

    @Override
    public boolean expand() {
        if (this.expandedTypeDefinition != null) {
            return false;
        }
        this.setMergedChildren(this.getTreeProperty().getTypeDefinitions().stream().flatMap(typeDefinition -> {
            if (this.getTreeProperty().isContainer()) {
                return this.expandContainerNode((TypeDefinition)typeDefinition, this.traverseContext);
            }
            return this.generateChildrenNodes(typeDefinition.getResolvedProperty(), typeDefinition.getPropertyGenerator().generateChildProperties(typeDefinition.getResolvedProperty()), this.nullInject, this.traverseContext).stream();
        }).collect(Collectors.toList()));
        this.expandedTypeDefinition = this.resolvedTypeDefinition;
        return true;
    }

    @Override
    public void forceExpand() {
        List<TraverseNode> newChildren = this.getTreeProperty().getTypeDefinitions().stream().flatMap(typeDefinition -> {
            if (this.getTreeProperty().isContainer()) {
                return this.expandContainerNode((TypeDefinition)typeDefinition, this.traverseContext.withParentProperties());
            }
            return this.generateChildrenNodes(typeDefinition.getResolvedProperty(), typeDefinition.getPropertyGenerator().generateChildProperties(typeDefinition.getResolvedProperty()), this.nullInject, this.traverseContext.withParentProperties()).stream();
        }).collect(Collectors.toList());
        this.setMergedChildren(newChildren);
        this.expandedTypeDefinition = this.resolvedTypeDefinition;
    }

    @Override
    public void forceExpand(TypeDefinition typeDefinition) {
        List<TraverseNode> children = this.getTreeProperty().isContainer() ? this.expandContainerNode(typeDefinition, this.traverseContext.withParentProperties()).collect(Collectors.toList()) : this.generateChildrenNodes(typeDefinition.getResolvedProperty(), typeDefinition.getPropertyGenerator().generateChildProperties(typeDefinition.getResolvedProperty()), this.nullInject, this.traverseContext.withParentProperties());
        this.setMergedChildren(children);
        this.expandedTypeDefinition = typeDefinition;
    }

    @Override
    public TraverseNodeMetadata getMetadata() {
        return this;
    }

    private Stream<TraverseNode> expandContainerNode(TypeDefinition typeDefinition, TraverseContext traverseContext) {
        TreeNodeManipulator appliedContainerInfoManipulator = this.getAppliedTreeNodeManipulator();
        ArbitraryContainerInfo containerInfo = appliedContainerInfoManipulator != null ? appliedContainerInfoManipulator.getContainerInfo() : null;
        PropertyGenerator propertyGenerator = typeDefinition.getPropertyGenerator();
        if (propertyGenerator instanceof LazyPropertyGenerator) {
            propertyGenerator = ((LazyPropertyGenerator)propertyGenerator).getDelegate();
        }
        if (propertyGenerator instanceof ElementPropertyGenerator) {
            ((ElementPropertyGenerator)propertyGenerator).updateContainerInfo(containerInfo);
        }
        List<Property> elementProperties = propertyGenerator.generateChildProperties(typeDefinition.getResolvedProperty());
        return this.generateChildrenNodes(typeDefinition.getResolvedProperty(), elementProperties, this.nullInject, traverseContext).stream();
    }

    public static DefaultTraverseNode generateRootNode(TreeRootProperty rootProperty, TraverseContext traverseContext) {
        return DefaultTraverseNode.generateObjectNode(rootProperty, null, rootProperty, null, 0.0, traverseContext);
    }

    static DefaultTraverseNode generateObjectNode(TreeRootProperty rootProperty, @Nullable Property resolvedParentProperty, Property property, @Nullable Integer propertySequence, double parentNullInject, TraverseContext context) {
        ContainerPropertyGenerator containerPropertyGenerator = context.getContainerPropertyGenerator(property);
        boolean container = containerPropertyGenerator != null;
        ObjectPropertyGenerator objectPropertyGenerator = context.getObjectPropertyGenerator(property);
        TreeProperty parentTreeProperty = context.getLastTreeProperty();
        ArbitraryProperty parentArbitraryProperty = parentTreeProperty != null ? parentTreeProperty.toArbitraryProperty(parentNullInject) : null;
        ObjectPropertyGeneratorContext objectPropertyGeneratorContext = new ObjectPropertyGeneratorContext(property, DefaultTraverseNode.resolveIndex(resolvedParentProperty, parentTreeProperty, propertySequence, context), parentArbitraryProperty, container, context.getPropertyNameResolver(property));
        ObjectProperty objectProperty = objectPropertyGenerator.generate(objectPropertyGeneratorContext);
        List<Property> candidateProperties = context.resolveCandidateProperties(property);
        List<ObjectProperty> objectProperties = context.getTreeProperties().stream().map(TreeProperty::getObjectProperty).collect(Collectors.toList());
        objectProperties.add(objectProperty);
        TreeNodeManipulator appliedContainerInfoManipulator = DefaultTraverseNode.resolveAppliedContainerInfoManipulator(container, context.getTreeManipulators(), objectProperties);
        List<TypeDefinition> typeDefinitions = candidateProperties.stream().map(concreteProperty -> {
            if (!container) {
                LazyPropertyGenerator lazyPropertyGenerator = context.getResolvedPropertyGenerator();
                return new DefaultTypeDefinition((Property)concreteProperty, lazyPropertyGenerator);
            }
            ElementPropertyGenerator containerElementPropertyGenerator = new ElementPropertyGenerator(property, containerPropertyGenerator, context.getArbitraryContainerInfoGenerator(property), null);
            LazyPropertyGenerator lazyPropertyGenerator = new LazyPropertyGenerator(containerElementPropertyGenerator);
            return new DefaultTypeDefinition((Property)concreteProperty, lazyPropertyGenerator);
        }).collect(Collectors.toList());
        double nullInject = context.getNullInjectGenerator(property).generate(objectPropertyGeneratorContext);
        TreeProperty treeProperty = new TreeProperty(objectProperty, container, typeDefinitions);
        TraverseContext nextTraverseContext = context.appendArbitraryProperty(treeProperty);
        DefaultTraverseNode newObjectNode = new DefaultTraverseNode(rootProperty, resolvedParentProperty, new CompositeTypeDefinition(typeDefinitions).getResolvedTypeDefinition(), treeProperty, nullInject, nextTraverseContext);
        if (appliedContainerInfoManipulator != null) {
            newObjectNode.getMetadata().addTreeNodeManipulator(appliedContainerInfoManipulator);
        }
        return newObjectNode;
    }

    @Nullable
    private static Integer resolveIndex(@Nullable Property resolvedParentProperty, @Nullable TreeProperty parentTreeProperty, @Nullable Integer propertySequence, TraverseContext context) {
        boolean parentContainer;
        if (resolvedParentProperty == null || parentTreeProperty == null) {
            return null;
        }
        boolean bl = parentContainer = context.getContainerPropertyGenerator(resolvedParentProperty) != null;
        if (!parentContainer) {
            return null;
        }
        if (propertySequence == null) {
            return null;
        }
        int index = propertySequence;
        if (parentTreeProperty.getObjectProperty().getProperty() instanceof MapEntryElementProperty) {
            index /= 2;
        }
        return index;
    }

    private List<TraverseNode> generateChildrenNodes(Property resolvedParentProperty, List<Property> childProperties, double parentNullInject, TraverseContext context) {
        ArrayList<TraverseNode> children = new ArrayList<TraverseNode>();
        for (int sequence = 0; sequence < childProperties.size(); ++sequence) {
            Property childProperty = childProperties.get(sequence);
            if (context.isTraversed(childProperty) && !(resolvedParentProperty instanceof MapEntryElementProperty)) continue;
            DefaultTraverseNode childNode = DefaultTraverseNode.generateObjectNode(this.rootProperty, resolvedParentProperty, childProperty, sequence, parentNullInject, context);
            children.add(childNode);
        }
        return children;
    }

    @Nullable
    private static TreeNodeManipulator resolveAppliedContainerInfoManipulator(boolean container, List<TreeNodeManipulator> containerInfoManipulators, List<ObjectProperty> objectProperties) {
        if (!container || objectProperties.isEmpty() || !(objectProperties.get(0).getProperty() instanceof TreeRootProperty)) {
            return null;
        }
        TreeNodeManipulator appliedContainerInfoManipulator = null;
        for (TreeNodeManipulator containerInfoManipulator : containerInfoManipulators) {
            if (!containerInfoManipulator.isMatch(objectProperties)) continue;
            appliedContainerInfoManipulator = containerInfoManipulator;
        }
        return appliedContainerInfoManipulator;
    }

    private List<TraverseNode> mergeWithNewChildren(List<TraverseNode> newChildren) {
        boolean expandChildNodes;
        boolean shrinkChildNodes;
        if (this.children == null) {
            return newChildren;
        }
        boolean bl = shrinkChildNodes = this.children.size() > newChildren.size();
        if (shrinkChildNodes) {
            return this.children.subList(0, newChildren.size());
        }
        boolean bl2 = expandChildNodes = this.children.size() < newChildren.size();
        if (expandChildNodes) {
            Map existingNodesByObjectProperty = this.children.stream().collect(Collectors.toMap(it -> it.getMetadata().getTreeProperty().getObjectProperty(), Function.identity()));
            ArrayList<TraverseNode> concatNewChildren = new ArrayList<TraverseNode>();
            for (TraverseNode newChild : newChildren) {
                TraverseNode existingNode = (TraverseNode)existingNodesByObjectProperty.get(newChild.getMetadata().getTreeProperty().getObjectProperty());
                if (existingNode != null) {
                    concatNewChildren.add(existingNode);
                    continue;
                }
                concatNewChildren.add(newChild);
            }
            return concatNewChildren;
        }
        return this.children;
    }
}

