/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.constraint;

import com.navercorp.fixturemonkey.api.constraint.JavaConstraintGenerator;
import com.navercorp.fixturemonkey.api.constraint.JavaContainerConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaDateTimeConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaDecimalConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaIntegerConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaStringConstraint;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import java.util.List;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="1.0.17", status=API.Status.EXPERIMENTAL)
public final class CompositeJavaConstraintGenerator
implements JavaConstraintGenerator {
    private final List<JavaConstraintGenerator> javaConstraintGenerators;

    public CompositeJavaConstraintGenerator(List<JavaConstraintGenerator> javaConstraintGenerators) {
        this.javaConstraintGenerators = javaConstraintGenerators;
    }

    @Override
    @Nullable
    public JavaStringConstraint generateStringConstraint(ArbitraryGeneratorContext context) {
        for (JavaConstraintGenerator javaConstraintGenerator : this.javaConstraintGenerators) {
            JavaStringConstraint constraint = javaConstraintGenerator.generateStringConstraint(context);
            if (constraint == null) continue;
            return constraint;
        }
        return null;
    }

    @Override
    @Nullable
    public JavaIntegerConstraint generateIntegerConstraint(ArbitraryGeneratorContext context) {
        for (JavaConstraintGenerator javaConstraintGenerator : this.javaConstraintGenerators) {
            JavaIntegerConstraint constraint = javaConstraintGenerator.generateIntegerConstraint(context);
            if (constraint == null) continue;
            return constraint;
        }
        return null;
    }

    @Override
    @Nullable
    public JavaDecimalConstraint generateDecimalConstraint(ArbitraryGeneratorContext context) {
        for (JavaConstraintGenerator javaConstraintGenerator : this.javaConstraintGenerators) {
            JavaDecimalConstraint constraint = javaConstraintGenerator.generateDecimalConstraint(context);
            if (constraint == null) continue;
            return constraint;
        }
        return null;
    }

    @Override
    @Nullable
    public JavaContainerConstraint generateContainerConstraint(ArbitraryGeneratorContext context) {
        for (JavaConstraintGenerator javaConstraintGenerator : this.javaConstraintGenerators) {
            JavaContainerConstraint constraint = javaConstraintGenerator.generateContainerConstraint(context);
            if (constraint == null) continue;
            return constraint;
        }
        return null;
    }

    @Override
    @Nullable
    public JavaDateTimeConstraint generateDateTimeConstraint(ArbitraryGeneratorContext context) {
        for (JavaConstraintGenerator javaConstraintGenerator : this.javaConstraintGenerators) {
            JavaDateTimeConstraint constraint = javaConstraintGenerator.generateDateTimeConstraint(context);
            if (constraint == null) continue;
            return constraint;
        }
        return null;
    }
}

