/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.property.CompositePropertyGenerator;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.6.2", status=API.Status.MAINTAINED)
public final class CompositeArbitraryGenerator
implements ArbitraryGenerator {
    private final List<ArbitraryGenerator> arbitraryGenerators;

    public CompositeArbitraryGenerator(List<ArbitraryGenerator> arbitraryGenerators) {
        this.arbitraryGenerators = arbitraryGenerators;
    }

    @Override
    public CombinableArbitrary<?> generate(ArbitraryGeneratorContext context) {
        CombinableArbitrary<?> generated = context.getGenerated();
        for (ArbitraryGenerator arbitraryGenerator : this.arbitraryGenerators) {
            generated = arbitraryGenerator.generate(context);
            context.setGenerated(generated);
        }
        return generated;
    }

    @Override
    @Nullable
    public PropertyGenerator getRequiredPropertyGenerator(Property property) {
        ArrayList<PropertyGenerator> propertyGenerators = new ArrayList<PropertyGenerator>();
        for (ArbitraryGenerator arbitraryGenerator : this.arbitraryGenerators) {
            PropertyGenerator propertyGenerator = arbitraryGenerator.getRequiredPropertyGenerator(property);
            if (propertyGenerator == null) continue;
            propertyGenerators.add(propertyGenerator);
        }
        if (propertyGenerators.isEmpty()) {
            return null;
        }
        return new CompositePropertyGenerator(propertyGenerators);
    }
}

