/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.MapKeyElementProperty;
import com.navercorp.fixturemonkey.api.property.MapValueElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.TypeParameterProperty;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class MapContainerPropertyGenerator
implements ContainerPropertyGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapContainerPropertyGenerator.class);
    public static final MapContainerPropertyGenerator INSTANCE = new MapContainerPropertyGenerator();

    @Override
    public ContainerProperty generate(ContainerPropertyGeneratorContext context) {
        Property property = context.getProperty();
        List<AnnotatedType> genericsTypes = Types.getGenericsTypes(property.getAnnotatedType());
        AnnotatedType keyType = !genericsTypes.isEmpty() ? genericsTypes.get(0) : DEFAULT_ELEMENT_RAW_TYPE.getAnnotatedType();
        AnnotatedType valueType = genericsTypes.size() > 1 ? genericsTypes.get(1) : DEFAULT_ELEMENT_RAW_TYPE.getAnnotatedType();
        Class<?> actualKeyType = Types.getActualType(keyType);
        ArbitraryContainerInfo containerInfo = context.getContainerInfo();
        if (actualKeyType.isEnum()) {
            int enumSize = EnumSet.allOf(actualKeyType).size();
            if (containerInfo.getElementMaxSize() > enumSize) {
                LOGGER.warn("Map key enum should not be bigger than enum size. enum size : " + enumSize);
            }
            containerInfo = new ArbitraryContainerInfo(Math.min(containerInfo.getElementMinSize(), enumSize), Math.min(containerInfo.getElementMaxSize(), enumSize));
        }
        int size = containerInfo.getRandomSize();
        ArrayList<Property> childProperties = new ArrayList<Property>();
        for (int sequence = 0; sequence < size; ++sequence) {
            childProperties.add(new MapEntryElementProperty(property, new MapKeyElementProperty(property, new TypeParameterProperty(keyType), sequence), new MapValueElementProperty(property, new TypeParameterProperty(valueType), sequence)));
        }
        return new ContainerProperty(childProperties, containerInfo);
    }
}

