/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.DefaultContainerElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.TypeParameterProperty;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class SetContainerPropertyGenerator
implements ContainerPropertyGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetContainerPropertyGenerator.class);
    public static final SetContainerPropertyGenerator INSTANCE = new SetContainerPropertyGenerator();

    @Override
    public ContainerProperty generate(ContainerPropertyGeneratorContext context) {
        Property property = context.getProperty();
        List<AnnotatedType> elementTypes = Types.getGenericsTypes(property.getAnnotatedType());
        AnnotatedType elementType = elementTypes.size() == 1 ? elementTypes.get(0) : DEFAULT_ELEMENT_RAW_TYPE.getAnnotatedType();
        ArbitraryContainerInfo containerInfo = context.getContainerInfo();
        Class<?> actualElementType = Types.getActualType(elementType.getType());
        if (actualElementType.isEnum()) {
            int enumSize = EnumSet.allOf(actualElementType).size();
            if (containerInfo.getElementMaxSize() > enumSize) {
                LOGGER.warn("Set of enum should not be bigger than enum size. enum size : " + enumSize);
            }
            containerInfo = new ArbitraryContainerInfo(Math.min(containerInfo.getElementMinSize(), enumSize), Math.min(containerInfo.getElementMaxSize(), enumSize));
        }
        int size = containerInfo.getRandomSize();
        ArrayList<Property> childProperties = new ArrayList<Property>();
        for (int sequence = 0; sequence < size; ++sequence) {
            childProperties.add(new DefaultContainerElementProperty(property, new TypeParameterProperty(elementType), null, sequence));
        }
        return new ContainerProperty(childProperties, containerInfo);
    }
}

