/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.introspector.InvocationHandlerBuilder;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.MethodProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.5.5", status=API.Status.MAINTAINED)
public final class AnonymousArbitraryIntrospector
implements ArbitraryIntrospector,
Matcher {
    public static final AnonymousArbitraryIntrospector INSTANCE = new AnonymousArbitraryIntrospector();
    private static final Logger LOGGER = LoggerFactory.getLogger(AnonymousArbitraryIntrospector.class);

    @Override
    public boolean match(Property property) {
        return Modifier.isInterface(Types.getActualType(property.getType()).getModifiers());
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property property = context.getResolvedProperty();
        Class<?> type = Types.getActualType(property.getType());
        if (!this.match(property)) {
            LOGGER.warn("Given type {} is not an interface. You must use another ArbitraryIntrospector", type);
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        return new ArbitraryIntrospectorResult(CombinableArbitrary.objectBuilder().properties(context.getCombinableArbitrariesByArbitraryProperty()).build(arbitrariesByPropertyName -> {
            List<ArbitraryProperty> childrenProperties = context.getChildren();
            InvocationHandlerBuilder invocationHandlerBuilder = new InvocationHandlerBuilder(type, new HashMap<String, Object>());
            for (ArbitraryProperty arbitraryProperty : childrenProperties) {
                Property childProperty = arbitraryProperty.getObjectProperty().getProperty();
                if (!(childProperty instanceof MethodProperty)) continue;
                MethodProperty methodProperty = (MethodProperty)childProperty;
                Object combined = arbitrariesByPropertyName.get(arbitraryProperty);
                invocationHandlerBuilder.put(methodProperty.getMethodName(), combined);
            }
            if (invocationHandlerBuilder.isEmpty()) {
                return null;
            }
            return type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, invocationHandlerBuilder.build()));
        }));
    }
}

