/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.ContainerElementProperty;
import com.navercorp.fixturemonkey.api.property.ElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.TypeParameterProperty;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="1.0.17", status=API.Status.EXPERIMENTAL)
public final class SingleElementProperty
extends ElementProperty
implements ContainerElementProperty {
    private final Property containerProperty;
    private final Property elementProperty;

    @Deprecated
    public SingleElementProperty(Property containerProperty) {
        super(containerProperty, containerProperty.getAnnotatedType(), null, 0);
        this.containerProperty = containerProperty;
        this.elementProperty = new TypeParameterProperty(containerProperty.getAnnotatedType());
    }

    public SingleElementProperty(Property containerProperty, Property elementProperty) {
        super(containerProperty, containerProperty.getAnnotatedType(), null, 0);
        this.containerProperty = containerProperty;
        this.elementProperty = elementProperty;
    }

    @Override
    public Type getType() {
        return this.getAnnotatedType().getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.elementProperty.getAnnotatedType();
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.containerProperty.getAnnotations();
    }

    @Override
    @Nullable
    public Object getValue(Object instance) {
        Class<?> actualType = Types.getActualType(instance.getClass());
        if (this.isOptional(actualType)) {
            return this.getOptionalValue(instance);
        }
        return instance;
    }

    @Override
    public Property getContainerProperty() {
        return this.containerProperty;
    }

    @Override
    public Property getElementProperty() {
        return this;
    }

    @Override
    public int getSequence() {
        return 0;
    }

    @Override
    @Nullable
    public Integer getIndex() {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SingleElementProperty that = (SingleElementProperty)obj;
        return Objects.equals(this.containerProperty, that.containerProperty) && Objects.equals(this.elementProperty, that.elementProperty);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.containerProperty, this.elementProperty);
    }

    private boolean isOptional(Class<?> type) {
        return Optional.class.isAssignableFrom(type) || OptionalInt.class.isAssignableFrom(type) || OptionalLong.class.isAssignableFrom(type) || OptionalDouble.class.isAssignableFrom(type);
    }

    private Object getOptionalValue(Object obj) {
        Class<?> actualType = Types.getActualType(obj.getClass());
        if (Optional.class.isAssignableFrom(actualType)) {
            return ((Optional)obj).orElse(null);
        }
        if (OptionalInt.class.isAssignableFrom(actualType)) {
            return ((OptionalInt)obj).orElse(0);
        }
        if (OptionalLong.class.isAssignableFrom(actualType)) {
            return ((OptionalLong)obj).orElse(0L);
        }
        if (OptionalDouble.class.isAssignableFrom(actualType)) {
            return ((OptionalDouble)obj).orElse(Double.NaN);
        }
        throw new IllegalArgumentException("given value is not optional, actual type : " + actualType);
    }
}

