/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.CandidateConcretePropertyResolver;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyUtils;
import com.navercorp.fixturemonkey.api.type.Types;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apiguardian.api.API;

@API(since="1.0.21", status=API.Status.EXPERIMENTAL)
public final class SealedTypeCandidateConcretePropertyResolver
implements CandidateConcretePropertyResolver {
    @Override
    public List<Property> resolve(Property property) {
        Class<?> actualType = Types.getActualType(property.getType());
        Set<Class<?>> permittedSubclasses = SealedTypeCandidateConcretePropertyResolver.collectPermittedSubclasses(actualType);
        return permittedSubclasses.stream().map(PropertyUtils::toProperty).toList();
    }

    private static Set<Class<?>> collectPermittedSubclasses(Class<?> type) {
        HashSet subclasses = new HashSet();
        SealedTypeCandidateConcretePropertyResolver.doCollectPermittedSubclasses(type, subclasses);
        return subclasses;
    }

    private static void doCollectPermittedSubclasses(Class<?> type, Set<Class<?>> subclasses) {
        if (type.isSealed()) {
            for (Class<?> subclass : type.getPermittedSubclasses()) {
                SealedTypeCandidateConcretePropertyResolver.doCollectPermittedSubclasses(subclass, subclasses);
            }
        } else {
            subclasses.add(type);
        }
    }
}

