/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.arbitrary;

import com.navercorp.fixturemonkey.api.arbitrary.ContainerCombineArbitraryBuilder;
import com.navercorp.fixturemonkey.api.arbitrary.FilteredCombinableArbitrary;
import com.navercorp.fixturemonkey.api.arbitrary.FixedCombinableArbitrary;
import com.navercorp.fixturemonkey.api.arbitrary.IntegerCombinableArbitrary;
import com.navercorp.fixturemonkey.api.arbitrary.LazyCombinableArbitrary;
import com.navercorp.fixturemonkey.api.arbitrary.MappedCombinableArbitrary;
import com.navercorp.fixturemonkey.api.arbitrary.NullInjectCombinableArbitrary;
import com.navercorp.fixturemonkey.api.arbitrary.ObjectCombineArbitraryBuilder;
import com.navercorp.fixturemonkey.api.arbitrary.StringCombinableArbitrary;
import com.navercorp.fixturemonkey.api.arbitrary.UniqueCombinableArbitrary;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apiguardian.api.API;

@API(since="0.6.0", status=API.Status.MAINTAINED)
public interface CombinableArbitrary<T> {
    public static final CombinableArbitrary<?> NOT_GENERATED = CombinableArbitrary.from(null);
    public static final int DEFAULT_MAX_TRIES = 1000;
    public static final ServiceLoader<IntegerCombinableArbitrary> INTEGER_COMBINABLE_ARBITRARY_SERVICE_LOADER = ServiceLoader.load(IntegerCombinableArbitrary.class);
    public static final ServiceLoader<StringCombinableArbitrary> STRING_COMBINABLE_ARBITRARY_SERVICE_LOADER = ServiceLoader.load(StringCombinableArbitrary.class);

    public static <T> CombinableArbitrary<T> from(T object) {
        return new FixedCombinableArbitrary<T>(object);
    }

    public static <U> CombinableArbitrary<U> from(Supplier<U> supplier) {
        return CombinableArbitrary.from(LazyArbitrary.lazy(supplier));
    }

    public static <U> CombinableArbitrary<U> from(LazyArbitrary<U> lazyArbitrary) {
        return new LazyCombinableArbitrary<U>(lazyArbitrary);
    }

    public static ObjectCombineArbitraryBuilder objectBuilder() {
        return new ObjectCombineArbitraryBuilder();
    }

    public static ContainerCombineArbitraryBuilder containerBuilder() {
        return new ContainerCombineArbitraryBuilder();
    }

    public T combined();

    public Object rawValue();

    default public CombinableArbitrary<T> filter(Predicate<T> predicate) {
        return this.filter(1000, predicate);
    }

    default public CombinableArbitrary<T> filter(int tries, Predicate<T> predicate) {
        if (this instanceof FilteredCombinableArbitrary) {
            return new FilteredCombinableArbitrary<T>(tries, (FilteredCombinableArbitrary)this, predicate);
        }
        return new FilteredCombinableArbitrary<T>(tries, this, predicate);
    }

    default public <R> CombinableArbitrary<R> map(Function<T, R> mapper) {
        return new MappedCombinableArbitrary<T, R>(this, mapper);
    }

    default public CombinableArbitrary<T> injectNull(double nullProbability) {
        return new NullInjectCombinableArbitrary(this, nullProbability);
    }

    default public CombinableArbitrary<T> unique() {
        return new UniqueCombinableArbitrary(this, new ConcurrentHashMap<Object, Object>());
    }

    public void clear();

    public boolean fixed();

    @API(since="1.1.12", status=API.Status.EXPERIMENTAL)
    public static IntegerCombinableArbitrary integers() {
        return INTEGER_COMBINABLE_ARBITRARY_SERVICE_LOADER.iterator().next();
    }

    @API(since="1.1.12", status=API.Status.EXPERIMENTAL)
    public static StringCombinableArbitrary strings() {
        return STRING_COMBINABLE_ARBITRARY_SERVICE_LOADER.iterator().next();
    }
}

