/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.arbitrary;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.arbitrary.StringCombinableArbitraryDelegator;
import java.util.function.Predicate;
import org.apiguardian.api.API;

@API(since="1.1.12", status=API.Status.EXPERIMENTAL)
public interface StringCombinableArbitrary
extends CombinableArbitrary<String> {
    public static final int STRING_DEFAULT_MIN_LENGTH = 0;
    public static final int STRING_DEFAULT_MAX_LENGTH = 100;

    @Override
    public String rawValue();

    public StringCombinableArbitrary withLength(int var1, int var2);

    public StringCombinableArbitrary alphabetic();

    public StringCombinableArbitrary ascii();

    public StringCombinableArbitrary numeric();

    public StringCombinableArbitrary korean();

    default public StringCombinableArbitrary withMinLength(int min) {
        return this.withLength(min, 100);
    }

    default public StringCombinableArbitrary withMaxLength(int max) {
        return this.withLength(0, max);
    }

    default public StringCombinableArbitrary filter(Predicate<String> predicate) {
        return this.filter(1000, (Predicate)predicate);
    }

    default public StringCombinableArbitrary filter(int tries, Predicate<String> predicate) {
        return new StringCombinableArbitraryDelegator(CombinableArbitrary.super.filter(tries, predicate));
    }

    default public StringCombinableArbitrary filterCharacter(Predicate<Character> predicate) {
        return this.filterCharacter(1000, predicate);
    }

    public StringCombinableArbitrary filterCharacter(int var1, Predicate<Character> var2);

    default public StringCombinableArbitrary injectNull(double nullProbability) {
        return new StringCombinableArbitraryDelegator(CombinableArbitrary.super.injectNull(nullProbability));
    }

    default public StringCombinableArbitrary unique() {
        return new StringCombinableArbitraryDelegator(CombinableArbitrary.super.unique());
    }
}

