/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.arbitrary;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.arbitrary.StringCombinableArbitrary;
import java.util.function.Predicate;

final class StringCombinableArbitraryDelegator
implements StringCombinableArbitrary {
    private final CombinableArbitrary<String> delegate;

    public StringCombinableArbitraryDelegator(CombinableArbitrary<String> delegate) {
        this.delegate = delegate;
    }

    @Override
    public String combined() {
        return this.delegate.combined();
    }

    @Override
    public String rawValue() {
        return this.delegate.combined();
    }

    @Override
    public StringCombinableArbitrary withLength(int min, int max) {
        return new StringCombinableArbitraryDelegator(this.delegate.filter((T it) -> min <= it.length() && it.length() <= max));
    }

    @Override
    public StringCombinableArbitrary alphabetic() {
        return CombinableArbitrary.strings().alphabetic();
    }

    @Override
    public StringCombinableArbitrary ascii() {
        return CombinableArbitrary.strings().ascii();
    }

    @Override
    public StringCombinableArbitrary numeric() {
        return CombinableArbitrary.strings().numeric();
    }

    @Override
    public StringCombinableArbitrary korean() {
        return CombinableArbitrary.strings().korean();
    }

    @Override
    public StringCombinableArbitrary filter(int tries, Predicate<String> predicate) {
        return new StringCombinableArbitraryDelegator(this.delegate.filter(tries, predicate));
    }

    @Override
    public StringCombinableArbitrary filterCharacter(int tries, Predicate<Character> predicate) {
        return this.filter(tries, it -> it.chars().mapToObj(Character.class::cast).allMatch(predicate));
    }

    @Override
    public StringCombinableArbitrary unique() {
        return new StringCombinableArbitraryDelegator(this.delegate.unique());
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean fixed() {
        return this.delegate.fixed();
    }
}

