/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.engine;

import org.apiguardian.api.API;

@API(since="1.1.9", status=API.Status.EXPERIMENTAL)
public abstract class EngineUtils {
    private static final boolean USE_JQWIK_ENGINE;
    private static final boolean USE_KOTEST_ENGINE;

    public static boolean useJqwikEngine() {
        return USE_JQWIK_ENGINE;
    }

    public static boolean useKotestEngine() {
        return USE_KOTEST_ENGINE;
    }

    static {
        boolean useKotestEngine;
        boolean useJqwikEngine;
        try {
            Class.forName("net.jqwik.engine.SourceOfRandomness");
            useJqwikEngine = true;
        }
        catch (ClassNotFoundException e) {
            useJqwikEngine = false;
        }
        USE_JQWIK_ENGINE = useJqwikEngine;
        try {
            Class.forName("io.kotest.property.Arb");
            useKotestEngine = true;
        }
        catch (ClassNotFoundException e) {
            useKotestEngine = false;
        }
        USE_KOTEST_ENGINE = useKotestEngine;
    }
}

