/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.expression;

import com.navercorp.fixturemonkey.api.expression.JavaGetterMethodPropertySelector;
import com.navercorp.fixturemonkey.api.expression.JavaGetterMethodReference;
import com.navercorp.fixturemonkey.api.expression.JavaGetterPropertyFieldNameResolver;
import com.navercorp.fixturemonkey.api.property.CompositeProperty;
import com.navercorp.fixturemonkey.api.property.FieldProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyDescriptorProperty;
import com.navercorp.fixturemonkey.api.type.KotlinTypeDetector;
import com.navercorp.fixturemonkey.api.type.TypeCache;
import java.beans.PropertyDescriptor;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nullable;

abstract class JavaGetterPropertySelectors {
    private static final JavaGetterPropertyFieldNameResolver PROPERTY_FIELD_NAME_RESOLVER = new JavaGetterPropertyFieldNameResolver();

    JavaGetterPropertySelectors() {
    }

    static <T, R> JavaGetterMethodPropertySelector<T, R> resolvePropertySelector(JavaGetterMethodReference<T, R> methodRef) {
        try {
            Property resolvedProperty;
            Class<?> methodRefClass = methodRef.getClass();
            Method replaceMethod = methodRefClass.getDeclaredMethod("writeReplace", new Class[0]);
            replaceMethod.setAccessible(true);
            SerializedLambda lambda = (SerializedLambda)replaceMethod.invoke(methodRef, new Object[0]);
            String className = lambda.getImplClass().replace('/', '.');
            ClassLoader classLoader = methodRefClass.getClassLoader() != null ? methodRefClass.getClassLoader() : JavaGetterPropertySelectors.class.getClassLoader();
            Class<?> targetClass = Class.forName(className, true, classLoader);
            if (KotlinTypeDetector.isKotlinType(targetClass)) {
                throw new IllegalArgumentException("Kotlin type could not resolve property name. type: " + targetClass);
            }
            String fieldName = PROPERTY_FIELD_NAME_RESOLVER.resolveFieldName(targetClass, lambda.getImplMethodName());
            Property fieldProperty = JavaGetterPropertySelectors.resolveFieldProperty(targetClass, fieldName);
            Property propertyDescriptorProperty = JavaGetterPropertySelectors.resolvePropertyDescriptorProperty(targetClass, fieldName);
            if (fieldProperty != null && propertyDescriptorProperty != null) {
                resolvedProperty = new CompositeProperty(fieldProperty, propertyDescriptorProperty);
            } else if (fieldProperty != null) {
                resolvedProperty = fieldProperty;
            } else if (propertyDescriptorProperty != null) {
                resolvedProperty = propertyDescriptorProperty;
            } else {
                throw new IllegalArgumentException("Could not resolve a field or a JavaBeans getter by given lambda. type: " + targetClass);
            }
            return new JavaGetterMethodPropertySelector(targetClass, resolvedProperty);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not resolve a field or a JavaBeans getter by given lambda. lambda: " + methodRef, ex);
        }
    }

    @Nullable
    private static Property resolveFieldProperty(Class<?> targetClass, String fieldName) {
        Map<String, Field> fieldsByName = TypeCache.getFieldsByName(targetClass);
        if (!fieldsByName.containsKey(fieldName)) {
            return null;
        }
        return new FieldProperty(fieldsByName.get(fieldName));
    }

    @Nullable
    private static Property resolvePropertyDescriptorProperty(Class<?> targetClass, String fieldName) {
        Map<String, PropertyDescriptor> propertyDescriptorsByPropertyName = TypeCache.getPropertyDescriptorsByPropertyName(targetClass);
        if (!propertyDescriptorsByPropertyName.containsKey(fieldName)) {
            return null;
        }
        return new PropertyDescriptorProperty(propertyDescriptorsByPropertyName.get(fieldName));
    }
}

