/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import java.util.List;
import org.apiguardian.api.API;

@API(since="0.6.12", status=API.Status.MAINTAINED)
public final class CompositeArbitraryIntrospector
implements ArbitraryIntrospector {
    private final List<ArbitraryIntrospector> introspectors;

    public CompositeArbitraryIntrospector(List<ArbitraryIntrospector> introspectors) {
        this.introspectors = introspectors;
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        for (ArbitraryIntrospector introspector : this.introspectors) {
            CombinableArbitrary<?> introspected = introspector.introspect(context).getValue();
            context.setGenerated(introspected);
        }
        return new ArbitraryIntrospectorResult(context.getGenerated());
    }
}

