/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.ConstantProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import org.apiguardian.api.API;

@API(since="1.0.17", status=API.Status.EXPERIMENTAL)
public final class ConstantIntrospector
implements ArbitraryIntrospector,
Matcher {
    public static final ConstantIntrospector INSTANCE = new ConstantIntrospector();

    @Override
    public boolean match(Property property) {
        return property instanceof ConstantProperty;
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Property constantProperty = context.getResolvedProperty();
        if (!this.match(constantProperty)) {
            throw new IllegalArgumentException("Given type is not Constant Property. property: " + constantProperty);
        }
        return new ArbitraryIntrospectorResult(CombinableArbitrary.from(() -> constantProperty.getValue(null)));
    }
}

