/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.JavaTypeArbitraryGeneratorSet;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class JavaArbitraryIntrospector
implements ArbitraryIntrospector,
Matcher {
    private final Map<Class<?>, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>> introspector;

    public JavaArbitraryIntrospector(JavaTypeArbitraryGeneratorSet javaTypeArbitraryGeneratorSet) {
        this.introspector = this.introspectors(javaTypeArbitraryGeneratorSet);
    }

    @Override
    public boolean match(Property property) {
        Class<?> actualType = Types.getActualType(property.getType());
        return this.introspector.containsKey(actualType);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        Class<?> type = Types.getActualType(context.getResolvedType());
        return this.introspector.getOrDefault(type, ctx -> ArbitraryIntrospectorResult.NOT_INTROSPECTED).apply(context);
    }

    private Map<Class<?>, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>> introspectors(JavaTypeArbitraryGeneratorSet javaTypeArbitraryGeneratorSet) {
        HashMap<Class<BigDecimal>, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>> introspector = new HashMap<Class<BigDecimal>, Function<ArbitraryGeneratorContext, ArbitraryIntrospectorResult>>();
        introspector.put(String.class, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.strings((ArbitraryGeneratorContext)ctx)));
        introspector.put(Character.TYPE, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.characters((ArbitraryGeneratorContext)ctx)));
        introspector.put(Character.class, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.characters((ArbitraryGeneratorContext)ctx)));
        introspector.put(Short.TYPE, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.shorts((ArbitraryGeneratorContext)ctx)));
        introspector.put(Short.class, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.shorts((ArbitraryGeneratorContext)ctx)));
        introspector.put(Byte.TYPE, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.bytes((ArbitraryGeneratorContext)ctx)));
        introspector.put(Byte.class, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.bytes((ArbitraryGeneratorContext)ctx)));
        introspector.put(Double.TYPE, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.doubles((ArbitraryGeneratorContext)ctx)));
        introspector.put(Double.class, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.doubles((ArbitraryGeneratorContext)ctx)));
        introspector.put(Float.TYPE, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.floats((ArbitraryGeneratorContext)ctx)));
        introspector.put(Float.class, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.floats((ArbitraryGeneratorContext)ctx)));
        introspector.put(Integer.TYPE, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.integers((ArbitraryGeneratorContext)ctx)));
        introspector.put(Integer.class, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.integers((ArbitraryGeneratorContext)ctx)));
        introspector.put(Long.TYPE, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.longs((ArbitraryGeneratorContext)ctx)));
        introspector.put(Long.class, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.longs((ArbitraryGeneratorContext)ctx)));
        introspector.put(BigInteger.class, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.bigIntegers((ArbitraryGeneratorContext)ctx)));
        introspector.put(BigDecimal.class, ctx -> new ArbitraryIntrospectorResult(javaTypeArbitraryGeneratorSet.bigDecimals((ArbitraryGeneratorContext)ctx)));
        return Collections.unmodifiableMap(introspector);
    }
}

