/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.jqwik;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.RandomGenerator;
import org.apiguardian.api.API;

@API(since="0.6.9", status=API.Status.MAINTAINED)
public abstract class ArbitraryUtils {
    public static <T> CombinableArbitrary<T> toCombinableArbitrary(Arbitrary<T> arbitrary) {
        return CombinableArbitrary.from(LazyArbitrary.lazy(() -> {
            if (arbitrary != null) {
                return ArbitraryUtils.newThreadSafeArbitrary(arbitrary).sample();
            }
            return null;
        }));
    }

    public static <T> Arbitrary<T> newThreadSafeArbitrary(final Arbitrary<T> delegate) {
        return new Arbitrary<T>(){

            public RandomGenerator<T> generator(int genSize) {
                return delegate.generator(genSize);
            }

            public RandomGenerator<T> generator(int genSize, boolean withEdgeCases) {
                return delegate.generator(genSize);
            }

            public EdgeCases<T> edgeCases(int maxEdgeCases) {
                return delegate.edgeCases(maxEdgeCases);
            }
        };
    }
}

