/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.jqwik;

import com.navercorp.fixturemonkey.api.arbitrary.IntegerCombinableArbitrary;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import org.apiguardian.api.API;

@API(since="1.1.12", status=API.Status.EXPERIMENTAL)
public final class JqwikIntegerCombinableArbitrary
implements IntegerCombinableArbitrary {
    private final Arbitrary<Integer> integerArbitrary;

    public JqwikIntegerCombinableArbitrary() {
        this.integerArbitrary = Arbitraries.integers();
    }

    private JqwikIntegerCombinableArbitrary(Arbitrary<Integer> integerArbitrary) {
        this.integerArbitrary = integerArbitrary;
    }

    @Override
    public Integer combined() {
        return (Integer)this.integerArbitrary.sample();
    }

    @Override
    public Integer rawValue() {
        return this.combined();
    }

    @Override
    public IntegerCombinableArbitrary withRange(int minValue, int maxValue) {
        return new JqwikIntegerCombinableArbitrary((Arbitrary<Integer>)Arbitraries.integers().between(minValue, maxValue));
    }

    @Override
    public IntegerCombinableArbitrary positive() {
        return new JqwikIntegerCombinableArbitrary((Arbitrary<Integer>)Arbitraries.integers().greaterOrEqual(1));
    }

    @Override
    public IntegerCombinableArbitrary negative() {
        return new JqwikIntegerCombinableArbitrary((Arbitrary<Integer>)Arbitraries.integers().lessOrEqual(-1));
    }

    @Override
    public IntegerCombinableArbitrary even() {
        return new JqwikIntegerCombinableArbitrary((Arbitrary<Integer>)Arbitraries.integers().filter(it -> it % 2 == 0));
    }

    @Override
    public IntegerCombinableArbitrary odd() {
        return new JqwikIntegerCombinableArbitrary((Arbitrary<Integer>)Arbitraries.integers().filter(it -> it % 2 != 0));
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean fixed() {
        return false;
    }
}

