/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.jqwik;

import com.navercorp.fixturemonkey.api.arbitrary.StringCombinableArbitrary;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ListArbitrary;
import org.apiguardian.api.API;

@API(since="1.1.12", status=API.Status.EXPERIMENTAL)
public final class JqwikStringCombinableArbitrary
implements StringCombinableArbitrary {
    private final Arbitrary<Character> characterArbitrary;
    @Nullable
    private Integer minSize = null;
    @Nullable
    private Integer maxSize = null;

    public JqwikStringCombinableArbitrary() {
        this.characterArbitrary = Arbitraries.chars();
    }

    private JqwikStringCombinableArbitrary(Arbitrary<Character> characterArbitrary) {
        this.characterArbitrary = characterArbitrary;
    }

    @Override
    public String combined() {
        ListArbitrary characterListArbitrary = this.characterArbitrary.list();
        if (this.minSize != null) {
            characterListArbitrary = characterListArbitrary.ofMinSize(this.minSize.intValue());
        }
        if (this.maxSize != null) {
            characterListArbitrary = characterListArbitrary.ofMaxSize(this.maxSize.intValue());
        }
        List characters = (List)characterListArbitrary.sample();
        StringBuilder stringBuilder = new StringBuilder();
        for (Character character : characters) {
            stringBuilder.append(character);
        }
        return stringBuilder.toString();
    }

    @Override
    public String rawValue() {
        return this.combined();
    }

    @Override
    public StringCombinableArbitrary withLength(int minSize, int maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        return this;
    }

    @Override
    public StringCombinableArbitrary alphabetic() {
        return new JqwikStringCombinableArbitrary((Arbitrary<Character>)Arbitraries.chars().alpha());
    }

    @Override
    public StringCombinableArbitrary ascii() {
        return new JqwikStringCombinableArbitrary((Arbitrary<Character>)Arbitraries.chars().ascii());
    }

    @Override
    public StringCombinableArbitrary numeric() {
        return new JqwikStringCombinableArbitrary((Arbitrary<Character>)Arbitraries.chars().numeric());
    }

    @Override
    public StringCombinableArbitrary korean() {
        return new JqwikStringCombinableArbitrary((Arbitrary<Character>)Arbitraries.chars().filter(it -> '\uac00' <= it.charValue() && it.charValue() <= '\ud7a3'));
    }

    @Override
    public StringCombinableArbitrary filterCharacter(int tries, Predicate<Character> predicate) {
        return new JqwikStringCombinableArbitrary((Arbitrary<Character>)this.characterArbitrary.filter(tries, predicate));
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean fixed() {
        return false;
    }
}

