/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.matcher;

import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.ExactTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.matcher.MatcherMetadata;
import com.navercorp.fixturemonkey.api.property.Property;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.INTERNAL)
public class MatcherOperator<T>
implements Matcher {
    private final Matcher matcher;
    private final T operator;

    public MatcherOperator(Matcher matcher, T operator) {
        this.matcher = matcher;
        this.operator = operator;
    }

    public static <T, C> MatcherOperator<T> exactTypeMatchOperator(Class<C> type, T operator) {
        return new MatcherOperator<T>(new ExactTypeMatcher(type), operator);
    }

    public static <T, C> MatcherOperator<T> assignableTypeMatchOperator(Class<C> type, T operator) {
        return new MatcherOperator<T>(new AssignableTypeMatcher(type), operator);
    }

    @Override
    public boolean match(Property property, MatcherMetadata matcherMetadata) {
        return this.matcher.match(property, matcherMetadata);
    }

    @Override
    public boolean match(Property property) {
        return this.matcher.match(property);
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public T getOperator() {
        return this.operator;
    }
}

