/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.matcher;

import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.matcher.MatcherMetadata;
import com.navercorp.fixturemonkey.api.property.Property;
import org.apiguardian.api.API;

@API(since="1.1.15", status=API.Status.EXPERIMENTAL)
public final class NamedMatcher
implements Matcher {
    private final Matcher matcher;
    private final String registeredName;

    public NamedMatcher(Matcher matcher, String registeredName) {
        this.matcher = matcher;
        this.registeredName = registeredName;
    }

    @Override
    public boolean match(Property property) {
        return this.matcher.match(property);
    }

    @Override
    public boolean match(Property property, MatcherMetadata matcherMetadata) {
        return this.matcher.match(property) && matcherMetadata instanceof NamedMatcherMetadata && this.registeredName.equals(((NamedMatcherMetadata)matcherMetadata).getName());
    }

    public static NamedMatcherMetadata metadata(String name) {
        return new NamedMatcherMetadata(name);
    }

    @API(since="1.1.15", status=API.Status.EXPERIMENTAL)
    public static final class NamedMatcherMetadata
    implements MatcherMetadata {
        private final String name;

        private NamedMatcherMetadata(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

