/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.plugin;

import com.navercorp.fixturemonkey.api.arbitrary.MonkeyStringArbitrary;
import com.navercorp.fixturemonkey.api.constraint.CompositeJavaConstraintGenerator;
import com.navercorp.fixturemonkey.api.constraint.JavaConstraintGenerator;
import com.navercorp.fixturemonkey.api.constraint.JavaContainerConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaDateTimeConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaDecimalConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaIntegerConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaStringConstraint;
import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.jqwik.JavaTypeArbitraryGenerator;
import com.navercorp.fixturemonkey.api.jqwik.JqwikJavaArbitraryResolver;
import com.navercorp.fixturemonkey.api.jqwik.JqwikJavaTypeArbitraryGeneratorSet;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptionsBuilder;
import com.navercorp.fixturemonkey.api.plugin.Plugin;
import com.navercorp.fixturemonkey.api.type.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.jqwik.api.arbitraries.StringArbitrary;
import org.apiguardian.api.API;

@API(since="1.0.17", status=API.Status.EXPERIMENTAL)
public final class SimpleValueJqwikPlugin
implements Plugin {
    private static final Set<Character> ALLOWED_SPECIAL_UNRESERVED_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('-'), Character.valueOf('~')));
    private static final long DEFAULT_MIN_STRING_LENGTH = 0L;
    private static final long DEFAULT_MAX_STRING_LENGTH = 5L;
    private static final long DEFAULT_STRING_BUFFER_LENGTH = 3L;
    private static final long DEFAULT_MIN_NUMBER_VALUE = -10000L;
    private static final long DEFAULT_MAX_NUMBER_VALUE = 10000L;
    private static final long DEFAULT_NUMBER_BUFFER_VALUE = 100L;
    private static final int DEFAULT_MIN_CONTAINER_SIZE = 0;
    private static final int DEFAULT_MAX_CONTAINER_SIZE = 3;
    private static final int DEFAULT_CONTAINER_BUFFER_SIZE = 2;
    private static final long DEFAULT_MINUS_DAYS = 365L;
    private static final long DEFAULT_PLUS_DAYS = 365L;
    private static final long DEFAULT_DAYS_BUFFER = 30L;
    private static final Predicate<Character> DEFAULT_CHARACTER_PREDICATE = character -> {
        boolean isAlphabet = '0' <= character.charValue() && character.charValue() <= '9';
        boolean isNumeric = 'A' <= character.charValue() && character.charValue() <= 'z';
        return isAlphabet || isNumeric || ALLOWED_SPECIAL_UNRESERVED_CHARACTERS.contains(character);
    };
    private long minStringLength = 0L;
    private long maxStringLength = 5L;
    private boolean setMaxStringLength = false;
    private long minNumberValue = -10000L;
    private long maxNumberValue = 10000L;
    private boolean setMaxNumberValue = false;
    private int minContainerSize = 0;
    private int maxContainerSize = 3;
    private boolean setMaxContainerSize = false;
    private long minusDaysFromToday = 365L;
    private long plusDaysFromToday = 365L;
    private boolean setPlusDaysFromToday = false;
    private Predicate<Character> characterPredicate = DEFAULT_CHARACTER_PREDICATE;

    public SimpleValueJqwikPlugin minStringLength(long minStringLength) {
        this.minStringLength = minStringLength;
        return this;
    }

    public SimpleValueJqwikPlugin maxStringLength(long maxStringLength) {
        this.maxStringLength = maxStringLength;
        this.setMaxStringLength = true;
        return this;
    }

    public SimpleValueJqwikPlugin minNumberValue(long minNumberValue) {
        this.minNumberValue = minNumberValue;
        return this;
    }

    public SimpleValueJqwikPlugin maxNumberValue(long maxNumberValue) {
        this.maxNumberValue = maxNumberValue;
        this.setMaxNumberValue = true;
        return this;
    }

    public SimpleValueJqwikPlugin minContainerSize(int minContainerSize) {
        this.minContainerSize = minContainerSize;
        return this;
    }

    public SimpleValueJqwikPlugin maxContainerSize(int maxContainerSize) {
        this.maxContainerSize = maxContainerSize;
        this.setMaxContainerSize = true;
        return this;
    }

    public SimpleValueJqwikPlugin minusDaysFromToday(long minusDaysFromToday) {
        this.minusDaysFromToday = minusDaysFromToday;
        return this;
    }

    public SimpleValueJqwikPlugin plusDaysFromToday(long plusDaysFromToday) {
        this.plusDaysFromToday = plusDaysFromToday;
        this.setPlusDaysFromToday = true;
        return this;
    }

    public SimpleValueJqwikPlugin characterPredicate(Predicate<Character> characterPredicate) {
        this.characterPredicate = characterPredicate;
        return this;
    }

    @Override
    public void accept(FixtureMonkeyOptionsBuilder optionsBuilder) {
        long maxStringLength = this.maxStringLength;
        if (!this.setMaxStringLength) {
            maxStringLength = Math.max(5L, this.minStringLength + 3L);
        }
        long maxNumberValue = this.maxNumberValue;
        if (!this.setMaxNumberValue) {
            maxNumberValue = Math.max(10000L, this.minNumberValue + 100L);
        }
        int maxContainerSize = this.maxContainerSize;
        if (!this.setMaxContainerSize) {
            maxContainerSize = Math.max(3, this.minContainerSize + 2);
        }
        long plusDaysFromToday = this.plusDaysFromToday;
        if (!this.setPlusDaysFromToday) {
            plusDaysFromToday = Math.max(365L, this.minusDaysFromToday + 30L);
        }
        SimpleJavaConstraintGenerator simpleJavaConstraintGenerator = new SimpleJavaConstraintGenerator(this.minStringLength, maxStringLength, this.minNumberValue, maxNumberValue, this.minContainerSize, maxContainerSize, this.minusDaysFromToday, plusDaysFromToday);
        optionsBuilder.insertFirstJavaConstraintGeneratorCustomizer(javaConstraintGenerator -> new CompositeJavaConstraintGenerator(Arrays.asList(javaConstraintGenerator, simpleJavaConstraintGenerator))).javaTypeArbitraryGeneratorSet(javaConstraintGenerator -> new JqwikJavaTypeArbitraryGeneratorSet(new JavaTypeArbitraryGenerator(){

            @Override
            public StringArbitrary strings() {
                return new MonkeyStringArbitrary().filterCharacter(SimpleValueJqwikPlugin.this.characterPredicate);
            }
        }, new JqwikJavaArbitraryResolver((JavaConstraintGenerator)javaConstraintGenerator))).defaultArbitraryContainerInfoGenerator(containerType -> new ArbitraryContainerInfo(simpleJavaConstraintGenerator.minContainerSize, simpleJavaConstraintGenerator.maxContainerSize));
    }

    private static class SimpleJavaConstraintGenerator
    implements JavaConstraintGenerator {
        private final long stringMinLength;
        private final long stringMaxLength;
        private final long minNumberValue;
        private final long maxNumberValue;
        private final int minContainerSize;
        private final int maxContainerSize;
        private final long minusDaysFromToday;
        private final long plusDaysFromToday;

        public SimpleJavaConstraintGenerator(long stringMinLength, long stringMaxLength, long minNumberValue, long maxNumberValue, int minContainerSize, int maxContainerSize, long minusDaysFromToday, long plusDaysFromToday) {
            this.stringMinLength = stringMinLength;
            this.stringMaxLength = stringMaxLength;
            this.minNumberValue = minNumberValue;
            this.maxNumberValue = maxNumberValue;
            this.minContainerSize = minContainerSize;
            this.maxContainerSize = maxContainerSize;
            this.minusDaysFromToday = minusDaysFromToday;
            this.plusDaysFromToday = plusDaysFromToday;
        }

        @Override
        public JavaStringConstraint generateStringConstraint(ArbitraryGeneratorContext context) {
            return new JavaStringConstraint(BigInteger.valueOf(this.stringMinLength), BigInteger.valueOf(this.stringMaxLength), false, false, false, null, false);
        }

        @Override
        public JavaIntegerConstraint generateIntegerConstraint(ArbitraryGeneratorContext context) {
            BigInteger lowerBound = BigInteger.valueOf(this.minNumberValue);
            BigInteger upperBound = BigInteger.valueOf(this.maxNumberValue);
            Class<?> type = Types.getActualType(context.getResolvedType());
            if (type == Byte.class || type == Byte.TYPE) {
                upperBound = upperBound.min(BIG_INTEGER_MAX_BYTE);
                lowerBound = lowerBound.max(BIG_INTEGER_MIN_BYTE);
            }
            return new JavaIntegerConstraint(lowerBound, upperBound);
        }

        @Override
        public JavaDecimalConstraint generateDecimalConstraint(ArbitraryGeneratorContext context) {
            BigDecimal lowerBound = BigDecimal.valueOf(this.minNumberValue);
            BigDecimal upperBound = BigDecimal.valueOf(this.maxNumberValue);
            return new JavaDecimalConstraint(lowerBound, true, upperBound, true, 2);
        }

        @Override
        public JavaContainerConstraint generateContainerConstraint(ArbitraryGeneratorContext context) {
            return new JavaContainerConstraint(this.minContainerSize, this.maxContainerSize, false);
        }

        @Override
        public JavaDateTimeConstraint generateDateTimeConstraint(ArbitraryGeneratorContext context) {
            return new JavaDateTimeConstraint(() -> LocalDateTime.now().minusDays(this.minusDaysFromToday), () -> LocalDateTime.now().plusDays(this.plusDaysFromToday));
        }
    }
}

