/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.ContainerElementProperty;
import com.navercorp.fixturemonkey.api.property.ElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="1.1.6", status=API.Status.EXPERIMENTAL)
public final class DefaultContainerElementProperty
extends ElementProperty
implements ContainerElementProperty {
    private final Property containerProperty;
    private final Property elementProperty;
    private final int sequence;
    @Nullable
    private final Integer index;

    public DefaultContainerElementProperty(Property containerProperty, Property elementProperty, @Nullable Integer index, int sequence) {
        super(containerProperty, elementProperty.getAnnotatedType(), index, sequence);
        this.containerProperty = containerProperty;
        this.elementProperty = elementProperty;
        this.index = index;
        this.sequence = sequence;
    }

    @Override
    public Property getContainerProperty() {
        return this.containerProperty;
    }

    @Override
    public Property getElementProperty() {
        return this.elementProperty;
    }

    @Override
    public int getSequence() {
        return this.sequence;
    }

    @Override
    @Nullable
    public Integer getIndex() {
        return this.index;
    }

    @Override
    public Type getType() {
        return this.elementProperty.getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.elementProperty.getAnnotatedType();
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.elementProperty.getAnnotations();
    }

    @Override
    @Nullable
    public Object getValue(Object instance) {
        Class<?> actualType = Types.getActualType(instance.getClass());
        if (this.isOptional(actualType)) {
            return this.getOptionalValue(instance);
        }
        if (actualType.isArray()) {
            if (Array.getLength(instance) == 0) {
                return null;
            }
            return Array.get(instance, this.sequence);
        }
        if (List.class.isAssignableFrom(actualType)) {
            List list = (List)instance;
            if (list.isEmpty()) {
                return null;
            }
            return list.get(this.sequence);
        }
        if (Supplier.class.isAssignableFrom(actualType)) {
            return instance;
        }
        throw new IllegalArgumentException("given element value has no match sequence : " + this.sequence);
    }

    private boolean isOptional(Class<?> type) {
        return Optional.class.isAssignableFrom(type) || OptionalInt.class.isAssignableFrom(type) || OptionalLong.class.isAssignableFrom(type) || OptionalDouble.class.isAssignableFrom(type);
    }

    @Nullable
    private Object getOptionalValue(Object obj) {
        Class<?> actualType = Types.getActualType(obj.getClass());
        if (Optional.class.isAssignableFrom(actualType)) {
            return ((Optional)obj).orElse(null);
        }
        if (OptionalInt.class.isAssignableFrom(actualType)) {
            return ((OptionalInt)obj).orElse(0);
        }
        if (OptionalLong.class.isAssignableFrom(actualType)) {
            return ((OptionalLong)obj).orElse(0L);
        }
        if (OptionalDouble.class.isAssignableFrom(actualType)) {
            return ((OptionalDouble)obj).orElse(Double.NaN);
        }
        throw new IllegalArgumentException("given value is not optional, actual type : " + actualType);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultContainerElementProperty that = (DefaultContainerElementProperty)obj;
        return this.sequence == that.sequence && Objects.equals(this.containerProperty, that.containerProperty) && Objects.equals(this.elementProperty, that.elementProperty) && Objects.equals(this.index, that.index);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.containerProperty, this.elementProperty, this.sequence, this.index);
    }
}

