/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.container.ConcurrentLruCache;
import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;

@API(since="1.1.0", status=API.Status.EXPERIMENTAL)
public final class LazyPropertyGenerator
implements PropertyGenerator {
    private final PropertyGenerator delegate;
    private final Map<Property, LazyArbitrary<List<Property>>> childPropertyListsByProperty = new ConcurrentLruCache<Property, LazyArbitrary<List<Property>>>(32);

    public LazyPropertyGenerator(PropertyGenerator delegate) {
        this.delegate = delegate;
    }

    @Override
    public List<Property> generateChildProperties(Property property) {
        return (List)this.childPropertyListsByProperty.computeIfAbsent(property, p -> LazyArbitrary.lazy(() -> this.delegate.generateChildProperties((Property)p))).getValue();
    }

    public PropertyGenerator getDelegate() {
        return this.delegate;
    }
}

