/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.lazy.LazyArbitrary;
import com.navercorp.fixturemonkey.api.property.ContainerElementProperty;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.MapKeyElementProperty;
import com.navercorp.fixturemonkey.api.property.MapValueElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.TreeRootProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public final class PropertyPath
implements Comparable<PropertyPath> {
    private final Property property;
    @Nullable
    private final PropertyPath parentPropertyPath;
    private final int depth;
    private final LazyArbitrary<String> expression = LazyArbitrary.lazy(this::initExpression);

    public PropertyPath(Property property, @Nullable PropertyPath parentPropertyPath, int depth) {
        this.property = property;
        this.parentPropertyPath = parentPropertyPath;
        this.depth = depth;
    }

    public Property getProperty() {
        return this.property;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyPath that = (PropertyPath)obj;
        return this.depth == that.depth && this.property.equals(that.property) && Objects.equals(this.parentPropertyPath, that.parentPropertyPath);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.parentPropertyPath, this.depth);
    }

    @Override
    public int compareTo(PropertyPath obj) {
        return Integer.compare(obj.depth, this.depth);
    }

    public String getExpression() {
        return this.expression.getValue();
    }

    private String initExpression() {
        return this.parentPropertyPath == null ? "" : this.parentPropertyPath.getExpression() + this.getDelimiter() + this.getCurrentPropertyExpression();
    }

    private String getCurrentPropertyExpression() {
        if (this.property instanceof TreeRootProperty || this.property instanceof MapEntryElementProperty) {
            return "";
        }
        if (this.property instanceof MapKeyElementProperty) {
            return "{key}";
        }
        if (this.property instanceof MapValueElementProperty) {
            return "{value}";
        }
        if (this.property instanceof ContainerElementProperty) {
            return "[" + ((ContainerElementProperty)this.property).getIndex() + "]";
        }
        return this.property.getName();
    }

    private String getDelimiter() {
        if (this.property instanceof ContainerElementProperty || this.property instanceof TreeRootProperty || this.property instanceof MapEntryElementProperty || this.property instanceof MapKeyElementProperty || this.property instanceof MapValueElementProperty || this.parentPropertyPath == null || "".equals(this.parentPropertyPath.getExpression())) {
            return "";
        }
        return ".";
    }
}

