/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.tree;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ObjectProperty;
import com.navercorp.fixturemonkey.api.tree.TraverseNodePredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="1.1.4", status=API.Status.EXPERIMENTAL)
public class TreeNodeManipulator {
    private final List<TraverseNodePredicate> traverseNodePredicates;
    private ArbitraryContainerInfo containerInfo;
    private final int manipulatingSequence;

    public TreeNodeManipulator(List<TraverseNodePredicate> traverseNodePredicates, ArbitraryContainerInfo containerInfo, int manipulatingSequence) {
        this.traverseNodePredicates = traverseNodePredicates;
        this.containerInfo = containerInfo;
        this.manipulatingSequence = manipulatingSequence;
    }

    public TreeNodeManipulator copy() {
        return new TreeNodeManipulator(this.getTraverseNodePredicates(), new ArbitraryContainerInfo(this.containerInfo.getElementMinSize(), this.containerInfo.getElementMaxSize()), this.manipulatingSequence);
    }

    public List<TraverseNodePredicate> getTraverseNodePredicates() {
        return this.traverseNodePredicates;
    }

    public ArbitraryContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public TreeNodeManipulator withPrependNextNodePredicate(TraverseNodePredicate nextNodePredicate) {
        List nodePredicatesWithoutRoot = this.traverseNodePredicates.stream().filter(it -> !(it instanceof TraverseNodePredicate.StartTraverseNodePredicate)).collect(Collectors.toList());
        ArrayList<TraverseNodePredicate> newtraverseNodePredicates = new ArrayList<TraverseNodePredicate>();
        newtraverseNodePredicates.add(nextNodePredicate);
        newtraverseNodePredicates.addAll(nodePredicatesWithoutRoot);
        return new TreeNodeManipulator(newtraverseNodePredicates, this.containerInfo, this.manipulatingSequence);
    }

    public int getManipulatingSequence() {
        return this.manipulatingSequence;
    }

    public void fixed() {
        int fixedSize = this.containerInfo.getRandomSize();
        this.containerInfo = new ArbitraryContainerInfo(fixedSize, fixedSize);
    }

    public boolean isMatch(List<ObjectProperty> objectProperties) {
        int objectPropertiesSize = objectProperties.size();
        int traverseNodePredicatesize = this.traverseNodePredicates.size();
        boolean registered = this.traverseNodePredicates.get(0) instanceof TraverseNodePredicate.PropertyTraverseNodePredicate;
        if (!registered && traverseNodePredicatesize != objectPropertiesSize) {
            return false;
        }
        for (int i = 0; i < traverseNodePredicatesize; ++i) {
            ObjectProperty objectProperty;
            int reversedNextNodePredicateIndex = traverseNodePredicatesize - 1 - i;
            int reversedCurrentObjectPropertyIndex = objectPropertiesSize - 1 - i;
            TraverseNodePredicate nextNodePredicate = this.traverseNodePredicates.get(reversedNextNodePredicateIndex);
            if (nextNodePredicate.test(objectProperty = objectProperties.get(reversedCurrentObjectPropertyIndex))) continue;
            return false;
        }
        return true;
    }
}

