/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.type;

import com.navercorp.fixturemonkey.api.type.AnnotatedTypes;
import com.navercorp.fixturemonkey.api.type.GenericType;
import com.navercorp.fixturemonkey.api.type.TypeCache;
import com.navercorp.fixturemonkey.api.type.TypeReference;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.INTERNAL)
public abstract class Types {
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap;

    public static Class<?> getActualType(AnnotatedType annotatedType) {
        return Types.getActualType(annotatedType.getType());
    }

    public static Class<?> getActualType(Type type) {
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (GenericArrayType.class.isAssignableFrom(type.getClass())) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return Types.getActualType(genericArrayType.getGenericComponentType());
        }
        if (WildcardType.class.isAssignableFrom(type.getClass())) {
            WildcardType wildcardType = (WildcardType)type;
            Type upperBound = wildcardType.getUpperBounds()[0];
            if (upperBound == Object.class) {
                return GeneratingWildcardType.class;
            }
            return Types.getActualType(upperBound);
        }
        if (TypeVariable.class.isAssignableFrom(type.getClass())) {
            Object genericDeclaration = ((TypeVariable)type).getGenericDeclaration();
            if (genericDeclaration.getClass() == Class.class) {
                return Object.class;
            }
            throw new UnsupportedOperationException("Unsupported TypeVariable's generationDeclaration type. type: " + genericDeclaration.getClass());
        }
        if (ParameterizedType.class.isAssignableFrom(type.getClass())) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return Types.getActualType(rawType);
        }
        throw new UnsupportedOperationException("Unsupported Type to get actualType. type: " + type.getClass());
    }

    public static List<AnnotatedType> getGenericsTypes(AnnotatedType annotatedType) {
        Type type = annotatedType.getType();
        if (type.getClass() == Class.class) {
            return Collections.emptyList();
        }
        if (AnnotatedWildcardType.class.isAssignableFrom(annotatedType.getClass())) {
            AnnotatedWildcardType wildcardType = (AnnotatedWildcardType)annotatedType;
            return Types.getGenericsTypes(wildcardType.getAnnotatedUpperBounds()[0]);
        }
        if (TypeVariable.class.isAssignableFrom(type.getClass())) {
            Object genericDeclaration = ((TypeVariable)type).getGenericDeclaration();
            if (genericDeclaration.getClass() == Class.class) {
                return Collections.emptyList();
            }
            throw new UnsupportedOperationException("Unsupported TypeVariable's generationDeclaration type. type: " + genericDeclaration.getClass());
        }
        if (AnnotatedParameterizedType.class.isAssignableFrom(annotatedType.getClass())) {
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
            AnnotatedType[] rawTypes = parameterizedType.getAnnotatedActualTypeArguments();
            if (rawTypes == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(rawTypes);
        }
        if (ParameterizedType.class.isAssignableFrom(type.getClass())) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            return Arrays.stream(actualTypeArguments).map(Types::generateAnnotatedTypeWithoutAnnotation).collect(Collectors.toList());
        }
        if (WildcardType.class.isAssignableFrom(type.getClass())) {
            return Collections.singletonList(Types.generateAnnotatedTypeWithoutAnnotation(GeneratingWildcardType.class));
        }
        if (GenericArrayType.class.isAssignableFrom(type.getClass())) {
            Type genericComponentType = ((GenericArrayType)type).getGenericComponentType();
            return Types.getGenericsTypes(Types.generateAnnotatedTypeWithoutAnnotation(genericComponentType));
        }
        throw new UnsupportedOperationException("Unsupported Type to get genericsTypes. annotatedType: " + annotatedType);
    }

    public static AnnotatedType resolveWithTypeReferenceGenerics(AnnotatedType parentAnnotatedType, AnnotatedType currentAnnotatedType) {
        Type genericType = currentAnnotatedType.getType();
        if (!(genericType instanceof TypeVariable || genericType instanceof GenericArrayType || genericType instanceof AnnotatedParameterizedType || genericType instanceof ParameterizedType)) {
            return currentAnnotatedType;
        }
        AnnotatedType ownerTypeGenerics = Types.resolvesParentTypeGenerics(parentAnnotatedType, currentAnnotatedType);
        if (ownerTypeGenerics != null) {
            return ownerTypeGenerics;
        }
        Class<?> actualOwnerType = Types.getActualType(parentAnnotatedType.getType());
        AnnotatedType annotatedSuperClassType = actualOwnerType.getAnnotatedSuperclass();
        if (annotatedSuperClassType != null && ParameterizedType.class.isAssignableFrom(annotatedSuperClassType.getType().getClass())) {
            return Types.resolvesParentTypeGenerics(Types.getActualType(parentAnnotatedType.getType()).getAnnotatedSuperclass(), currentAnnotatedType);
        }
        List<AnnotatedType> genericsTypes = Types.getGenericsTypes(parentAnnotatedType);
        if (genericsTypes.isEmpty()) {
            if (currentAnnotatedType instanceof AnnotatedTypeVariable) {
                return Types.generateAnnotatedTypeWithoutAnnotation(Object.class);
            }
            return currentAnnotatedType;
        }
        return AnnotatedTypes.newAnnotatedTypeVariable(currentAnnotatedType, genericsTypes);
    }

    @Nullable
    private static AnnotatedType resolvesParentTypeGenerics(AnnotatedType parentAnnotatedType, AnnotatedType currentAnnotatedType) {
        if (!(parentAnnotatedType instanceof AnnotatedParameterizedType)) {
            return null;
        }
        AnnotatedParameterizedType parentAnnotatedParameterizedType = (AnnotatedParameterizedType)parentAnnotatedType;
        AnnotatedType[] parentGenericsTypes = parentAnnotatedParameterizedType.getAnnotatedActualTypeArguments();
        if (parentGenericsTypes == null || parentGenericsTypes.length == 0) {
            return currentAnnotatedType;
        }
        ParameterizedType parentParameterizedType = (ParameterizedType)parentAnnotatedParameterizedType.getType();
        Class<?> parentActualType = Types.getActualType(parentParameterizedType.getRawType());
        List<TypeVariable<Class<?>>> parentTypeVariableParameters = Arrays.asList(parentActualType.getTypeParameters());
        Type genericType = currentAnnotatedType.getType();
        if (TypeVariable.class.isAssignableFrom(genericType.getClass())) {
            int index = parentTypeVariableParameters.indexOf(genericType);
            return parentGenericsTypes[index];
        }
        if (genericType instanceof GenericArrayType) {
            return Types.resolveGenericsArrayType(parentAnnotatedType, currentAnnotatedType, parentGenericsTypes);
        }
        AnnotatedParameterizedType fieldParameterizedType = (AnnotatedParameterizedType)currentAnnotatedType;
        AnnotatedType[] fieldGenericsTypes = fieldParameterizedType.getAnnotatedActualTypeArguments();
        if (fieldGenericsTypes == null || fieldGenericsTypes.length == 0) {
            return fieldParameterizedType;
        }
        AnnotatedType[] resolvedGenericsTypes = new AnnotatedType[fieldGenericsTypes.length];
        Type[] resolvedTypes = new Type[fieldGenericsTypes.length];
        for (int i = 0; i < fieldGenericsTypes.length; ++i) {
            AnnotatedType generics = fieldGenericsTypes[i];
            if (generics instanceof AnnotatedParameterizedType || generics.getType().getClass() == Class.class) {
                resolvedGenericsTypes[i] = generics;
                resolvedTypes[i] = generics.getType();
                continue;
            }
            if (!TypeVariable.class.isAssignableFrom(generics.getType().getClass())) continue;
            TypeVariable typeVariable = (TypeVariable)generics.getType();
            for (int t = 0; t < parentTypeVariableParameters.size(); ++t) {
                Type parentTypeVariable = parentTypeVariableParameters.get(t);
                if (!parentTypeVariable.getTypeName().equals(typeVariable.getTypeName())) continue;
                generics = parentGenericsTypes[t];
                break;
            }
            resolvedGenericsTypes[i] = generics;
            resolvedTypes[i] = generics.getType();
        }
        ParameterizedType type = (ParameterizedType)fieldParameterizedType.getType();
        GenericType resolveType = new GenericType(type.getRawType(), resolvedTypes, type.getOwnerType());
        return AnnotatedTypes.newAnnotatedParameterizedType(resolvedGenericsTypes, resolveType, fieldParameterizedType.getAnnotations(), fieldParameterizedType.getDeclaredAnnotations(), parentAnnotatedType);
    }

    private static AnnotatedArrayType resolveGenericsArrayType(AnnotatedType parentAnnotatedType, AnnotatedType currentAnnotatedType, AnnotatedType[] ownerGenericsTypes) {
        GenericArrayType genericArrayType = (GenericArrayType)currentAnnotatedType.getType();
        ParameterizedType genericComponentType = (ParameterizedType)genericArrayType.getGenericComponentType();
        Type[] types = new Type[genericComponentType.getActualTypeArguments().length];
        for (int i = 0; i < ownerGenericsTypes.length; ++i) {
            types[i] = ownerGenericsTypes[i].getType();
        }
        GenericType genericComponentTypeWithGeneric = new GenericType(genericComponentType.getRawType(), types, genericComponentType.getOwnerType());
        GenericArrayType resolveType = () -> genericComponentTypeWithGeneric;
        return AnnotatedTypes.newAnnotatedArrayType(Types.generateAnnotatedTypeWithoutAnnotation(genericComponentTypeWithGeneric), resolveType, currentAnnotatedType.getAnnotations(), currentAnnotatedType.getDeclaredAnnotations(), parentAnnotatedType);
    }

    public static AnnotatedType resolveWithTypeReferenceGenerics(AnnotatedType parentType, PropertyDescriptor propertyDescriptor) {
        return Types.resolveWithTypeReferenceGenerics(parentType, TypeCache.getAnnotatedType(propertyDescriptor));
    }

    public static AnnotatedType getArrayComponentAnnotatedType(AnnotatedType annotatedType) {
        if (annotatedType instanceof AnnotatedArrayType) {
            AnnotatedArrayType annotatedArrayType = (AnnotatedArrayType)annotatedType;
            return annotatedArrayType.getAnnotatedGenericComponentType();
        }
        Class<?> type = Types.getActualType(annotatedType.getType());
        if (type.isArray()) {
            return Types.generateAnnotatedTypeWithoutAnnotation(type.getComponentType());
        }
        throw new IllegalArgumentException("given type is not Array type, annotatedType: " + annotatedType);
    }

    public static Class<?> getArrayComponentType(AnnotatedType annotatedType) {
        return Types.getActualType(Types.getArrayComponentAnnotatedType(annotatedType));
    }

    public static AnnotatedType generateAnnotatedTypeWithoutAnnotation(final Type type) {
        return new AnnotatedType(){

            @Override
            public Type getType() {
                return type;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return null;
            }

            @Override
            public Annotation[] getAnnotations() {
                return new Annotation[0];
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return new Annotation[0];
            }
        };
    }

    public static <T> T defaultIfNull(@Nullable T obj, Supplier<T> defaultValue) {
        return obj != null ? obj : defaultValue.get();
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = primitiveWrapperMap.get(cls);
        }
        return convertedClass;
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        return wrapperPrimitiveMap.get(cls);
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass) {
        return Types.isAssignable(cls, toClass, true);
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass, boolean autoboxing) {
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (autoboxing) {
            if (cls.isPrimitive() && !toClass.isPrimitive() && (cls = Types.primitiveToWrapper(cls)) == null) {
                return false;
            }
            if (toClass.isPrimitive() && !cls.isPrimitive() && (cls = Types.wrapperToPrimitive(cls)) == null) {
                return false;
            }
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls) || Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    public static List<Type> getGenericsTypes(ParameterizedType parameterizedType) {
        return Arrays.asList(parameterizedType.getActualTypeArguments());
    }

    public static boolean isIntegerType(Class<?> type) {
        return Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type);
    }

    public static boolean isDecimalType(Class<?> type) {
        return Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type) || BigDecimal.class.isAssignableFrom(type);
    }

    public static boolean isDateTimeType(Class<?> type) {
        return Calendar.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Instant.class.isAssignableFrom(type) || LocalDateTime.class.isAssignableFrom(type) || ZonedDateTime.class.isAssignableFrom(type) || OffsetDateTime.class.isAssignableFrom(type);
    }

    public static boolean isDateType(Class<?> type) {
        return Year.class.isAssignableFrom(type) || YearMonth.class.isAssignableFrom(type) || LocalDate.class.isAssignableFrom(type) || MonthDay.class.isAssignableFrom(type);
    }

    public static boolean isTimeType(Class<?> type) {
        return LocalTime.class.isAssignableFrom(type) || OffsetTime.class.isAssignableFrom(type);
    }

    public static boolean isJavaType(Class<?> type) {
        return type.isPrimitive() || Types.isJavaPackage(type);
    }

    private static boolean isJavaPackage(Class<?> type) {
        return type.getPackage() != null && (type.getPackage().getName().startsWith("java") || type.getPackage().getName().startsWith("sun"));
    }

    public static boolean isAssignableTypes(Class<?>[] froms, Class<?>[] tos) {
        if (froms.length != tos.length) {
            return false;
        }
        for (int i = 0; i < froms.length; ++i) {
            Class<?> from = froms[i];
            Class<?> to = tos[i];
            if (Types.isAssignable(from, to)) continue;
            return false;
        }
        return true;
    }

    public static TypeReference<?> toTypeReference(final AnnotatedType annotatedType) {
        return new TypeReference<Object>(){

            @Override
            public Type getType() {
                return annotatedType.getType();
            }

            @Override
            public AnnotatedType getAnnotatedType() {
                return annotatedType;
            }
        };
    }

    public static <T> T nullSafe(@Nullable T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("given value should not be null");
        }
        return obj;
    }

    static {
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
        wrapperPrimitiveMap = new HashMap();
        primitiveWrapperMap.forEach((primitiveClass, wrapperClass) -> {
            if (!primitiveClass.equals(wrapperClass)) {
                wrapperPrimitiveMap.put((Class<?>)wrapperClass, (Class<?>)primitiveClass);
            }
        });
    }

    public static class GeneratingWildcardType {
        private GeneratingWildcardType() {
        }
    }

    public static class UnidentifiableType {
        private UnidentifiableType() {
        }
    }
}

