/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.arbitrary;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.6.0", status=API.Status.MAINTAINED)
final class ContainerCombinableArbitrary<T>
implements CombinableArbitrary<T> {
    private static final Object EXISTED = new Object();
    private final List<CombinableArbitrary<?>> combinableArbitraryList;
    private final Function<List<Object>, T> combinator;
    private final Map<Object, Object> generatedMap;

    ContainerCombinableArbitrary(List<CombinableArbitrary<?>> combinableArbitraryList, Function<List<Object>, T> combinator, Map<Object, Object> generatedMap) {
        this.combinableArbitraryList = combinableArbitraryList;
        this.combinator = combinator;
        this.generatedMap = generatedMap;
    }

    @Override
    public T combined() {
        List combinedList = this.combinableArbitraryList.stream().map(CombinableArbitrary::combined).collect(Collectors.toList());
        return this.combinator.apply(combinedList);
    }

    @Override
    public Object rawValue() {
        List rawValues = this.combinableArbitraryList.stream().map(CombinableArbitrary::rawValue).collect(Collectors.toList());
        return this.combinator.apply(rawValues);
    }

    @Override
    public void clear() {
        this.combinableArbitraryList.forEach(arbitrary -> {
            if (!arbitrary.fixed()) {
                arbitrary.clear();
            }
        });
    }

    @Override
    public boolean fixed() {
        if (this.combinableArbitraryList.isEmpty()) {
            return false;
        }
        return this.combinableArbitraryList.stream().allMatch(CombinableArbitrary::fixed);
    }

    @Override
    public CombinableArbitrary<T> unique() {
        List<CombinableArbitrary<?>> uniqueCombinableArbitraryList = this.combinableArbitraryList.stream().map((? super T arbitrary) -> arbitrary.filter(it -> {
            if (!this.generatedMap.containsKey(it)) {
                this.generatedMap.put(it, EXISTED);
                return true;
            }
            return false;
        })).collect(Collectors.toList());
        return CombinableArbitrary.containerBuilder().elements(uniqueCombinableArbitraryList).build(this.combinator);
    }
}

