/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.NullInjectGenerator;
import com.navercorp.fixturemonkey.api.generator.ObjectPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class DefaultNullInjectGenerator
implements NullInjectGenerator {
    public static final double NOT_NULL_INJECT = 0.0;
    public static final double DEFAULT_NULL_INJECT = 0.2;
    public static final double ALWAYS_NULL_INJECT = 1.0;
    public static final List<String> DEFAULT_NULLABLE_ANNOTATION_TYPES = Collections.unmodifiableList(Arrays.asList("javax.annotation.Nullable", "jakarta.annotation.Nullable", "org.springframework.lang.Nullable", "org.checkerframework.checker.nullness.qual.Nullable", "org.eclipse.jgit.annotations.Nullable", "org.jmlspecs.annotation.Nullable"));
    public static final List<String> DEFAULT_NOTNULL_ANNOTATION_TYPES = Collections.unmodifiableList(Arrays.asList("javax.annotation.Nonnull", "jakarta.annotation.Nonnull", "javax.validation.constraints.NotNull", "jakarta.validation.constraints.NotNull", "org.springframework.lang.NonNull", "org.checkerframework.checker.nullness.qual.NonNull", "org.jmlspecs.annotation.NonNull"));
    private final double defaultNullInject;
    private final boolean nullableContainer;
    private final boolean defaultNotNull;
    private final boolean nullableElement;
    private final Set<String> nullableAnnotationTypes;
    private final Set<String> notNullAnnotationTypes;

    public DefaultNullInjectGenerator() {
        this(0.2, false, false, false, new HashSet<String>(DEFAULT_NULLABLE_ANNOTATION_TYPES), new HashSet<String>(DEFAULT_NOTNULL_ANNOTATION_TYPES));
    }

    public DefaultNullInjectGenerator(double defaultNullInject, boolean nullableContainer, boolean defaultNotNull, boolean nullableElement, Set<String> nullableAnnotationTypes, Set<String> notNullAnnotationTypes) {
        this.defaultNullInject = defaultNullInject;
        this.nullableContainer = nullableContainer;
        this.defaultNotNull = defaultNotNull;
        this.nullableElement = nullableElement;
        this.nullableAnnotationTypes = nullableAnnotationTypes;
        this.notNullAnnotationTypes = notNullAnnotationTypes;
    }

    public static DefaultNullInjectGenerator of(double defaultNullInject, boolean nullableContainer, boolean defaultNotNull, boolean nullableElement, Set<Class<? extends Annotation>> nullableAnnotationTypes, Set<Class<? extends Annotation>> notNullAnnotationTypes) {
        return new DefaultNullInjectGenerator(defaultNullInject, nullableContainer, defaultNotNull, nullableElement, nullableAnnotationTypes.stream().map(Class::getName).collect(Collectors.toSet()), notNullAnnotationTypes.stream().map(Class::getName).collect(Collectors.toSet()));
    }

    @Override
    public double generate(ObjectPropertyGeneratorContext context) {
        if (context.isRootContext()) {
            return 0.0;
        }
        if (Types.getActualType(context.getProperty().getType()).isPrimitive()) {
            return 0.0;
        }
        Boolean nullable = context.getProperty().isNullable();
        if (nullable == null) {
            nullable = !this.defaultNotNull;
        }
        Set annotations = context.getProperty().getAnnotations().stream().map(it -> it.annotationType().getName()).collect(Collectors.toSet());
        if (!nullable.booleanValue()) {
            boolean hasNullableAnnotation = annotations.stream().anyMatch(this.nullableAnnotationTypes::contains);
            if (hasNullableAnnotation) {
                nullable = true;
            }
        }
        if (nullable.booleanValue()) {
            boolean hasNotNullAnnotation = annotations.stream().anyMatch(this.notNullAnnotationTypes::contains);
            if (hasNotNullAnnotation) {
                nullable = false;
            }
        }
        if (context.isContainer() && context.getProperty().isNullable() == null) {
            nullable = this.nullableContainer;
        }
        if (context.getOwnerProperty() != null && context.getOwnerProperty().isContainer()) {
            nullable = this.nullableElement;
        }
        return nullable != false ? this.defaultNullInject : 0.0;
    }
}

