/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.MapEntryElementProperty;
import com.navercorp.fixturemonkey.api.property.MapKeyElementProperty;
import com.navercorp.fixturemonkey.api.property.MapValueElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class MapContainerPropertyGenerator
implements ContainerPropertyGenerator {
    public static final MapContainerPropertyGenerator INSTANCE = new MapContainerPropertyGenerator();
    private static final Logger LOGGER = LoggerFactory.getLogger(MapContainerPropertyGenerator.class);

    @Override
    public ContainerProperty generate(ContainerPropertyGeneratorContext context) {
        Property property = context.getProperty();
        List<AnnotatedType> genericsTypes = Types.getGenericsTypes(property.getAnnotatedType());
        if (genericsTypes.size() != 2) {
            throw new IllegalArgumentException("Map genericsTypes must be have 2 generics type for key and value. propertyType: " + property.getType() + ", genericsTypes: " + genericsTypes);
        }
        AnnotatedType keyType = genericsTypes.get(0);
        AnnotatedType valueType = genericsTypes.get(1);
        Class<?> actualKeyType = Types.getActualType(keyType);
        ArbitraryContainerInfo containerInfo = context.getContainerInfo();
        if (actualKeyType.isEnum()) {
            int enumSize = EnumSet.allOf(actualKeyType).size();
            if (containerInfo.getElementMaxSize() > enumSize) {
                LOGGER.warn("Map key enum should not be bigger than enum size. enum size : " + enumSize);
            }
            containerInfo = new ArbitraryContainerInfo(Math.min(containerInfo.getElementMinSize(), enumSize), Math.min(containerInfo.getElementMaxSize(), enumSize));
        }
        int size = containerInfo.getRandomSize();
        ArrayList<Property> childProperties = new ArrayList<Property>();
        for (int sequence = 0; sequence < size; ++sequence) {
            childProperties.add(new MapEntryElementProperty(property, new MapKeyElementProperty(property, keyType, sequence), new MapValueElementProperty(property, valueType, sequence)));
        }
        return new ContainerProperty(childProperties, containerInfo);
    }
}

