/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyNameResolver;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ObjectProperty {
    private final Property property;
    private final PropertyNameResolver propertyNameResolver;
    @Nullable
    private final Integer elementIndex;

    public ObjectProperty(Property property, PropertyNameResolver propertyNameResolver, @Nullable Integer elementIndex) {
        this.property = property;
        this.propertyNameResolver = propertyNameResolver;
        this.elementIndex = elementIndex;
    }

    public Property getProperty() {
        return this.property;
    }

    public PropertyNameResolver getPropertyNameResolver() {
        return this.propertyNameResolver;
    }

    public String getResolvedPropertyName() {
        return this.getPropertyNameResolver().resolve(this.property);
    }

    @Nullable
    public Integer getElementIndex() {
        return this.elementIndex;
    }

    public boolean isRoot() {
        return this.property instanceof RootProperty;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectProperty that = (ObjectProperty)obj;
        return this.property.equals(that.property) && Objects.equals(this.getResolvedPropertyName(), that.getResolvedPropertyName()) && Objects.equals(this.elementIndex, that.elementIndex);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.getResolvedPropertyName(), this.elementIndex);
    }
}

