/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.ElementProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class SetContainerPropertyGenerator
implements ContainerPropertyGenerator {
    public static final SetContainerPropertyGenerator INSTANCE = new SetContainerPropertyGenerator();
    private static final Logger LOGGER = LoggerFactory.getLogger(SetContainerPropertyGenerator.class);

    @Override
    public ContainerProperty generate(ContainerPropertyGeneratorContext context) {
        Property property = context.getProperty();
        List<AnnotatedType> elementTypes = Types.getGenericsTypes(property.getAnnotatedType());
        if (elementTypes.size() != 1) {
            throw new IllegalArgumentException("Set elementsTypes must be have 1 generics type for element. propertyType: " + property.getType() + ", elementTypes: " + elementTypes);
        }
        AnnotatedType elementType = elementTypes.get(0);
        ArbitraryContainerInfo containerInfo = context.getContainerInfo();
        Class<?> actualElementType = Types.getActualType(elementType.getType());
        if (actualElementType.isEnum()) {
            int enumSize = EnumSet.allOf(actualElementType).size();
            if (containerInfo.getElementMaxSize() > enumSize) {
                LOGGER.warn("Set of enum should not be bigger than enum size. enum size : " + enumSize);
            }
            containerInfo = new ArbitraryContainerInfo(Math.min(containerInfo.getElementMinSize(), enumSize), Math.min(containerInfo.getElementMaxSize(), enumSize));
        }
        int size = containerInfo.getRandomSize();
        ArrayList<Property> childProperties = new ArrayList<Property>();
        for (int sequence = 0; sequence < size; ++sequence) {
            childProperties.add(new ElementProperty(property, elementType, null, sequence));
        }
        return new ContainerProperty(childProperties, containerInfo);
    }
}

