/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.introspector;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospector;
import com.navercorp.fixturemonkey.api.introspector.ArbitraryIntrospectorResult;
import com.navercorp.fixturemonkey.api.matcher.AssignableTypeMatcher;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.matcher.SingleGenericTypeMatcher;
import com.navercorp.fixturemonkey.api.property.Property;
import java.util.LinkedList;
import java.util.Queue;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class QueueIntrospector
implements ArbitraryIntrospector,
Matcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueIntrospector.class);
    private static final Matcher MATCHER = new AssignableTypeMatcher(Queue.class);

    @Override
    public boolean match(Property property) {
        return SingleGenericTypeMatcher.SINGLE_GENERIC_TYPE_MATCHER.match(property) && MATCHER.match(property);
    }

    @Override
    public ArbitraryIntrospectorResult introspect(ArbitraryGeneratorContext context) {
        ArbitraryProperty property = context.getArbitraryProperty();
        if (!property.isContainer() || !this.match(context.getResolvedProperty())) {
            LOGGER.info("Given type {} is not Queue type.", (Object)context.getResolvedType());
            return ArbitraryIntrospectorResult.NOT_INTROSPECTED;
        }
        return new ArbitraryIntrospectorResult(CombinableArbitrary.containerBuilder().elements(context.getElementCombinableArbitraryList()).build(LinkedList::new));
    }
}

