/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.instantiator.InstantiatorUtils;
import com.navercorp.fixturemonkey.api.matcher.Matcher;
import com.navercorp.fixturemonkey.api.property.ConstructorProperty;
import com.navercorp.fixturemonkey.api.property.ConstructorPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.FieldProperty;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyGenerator;
import com.navercorp.fixturemonkey.api.type.TypeCache;
import com.navercorp.fixturemonkey.api.type.TypeReference;
import com.navercorp.fixturemonkey.api.type.Types;
import java.beans.ConstructorProperties;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(since="0.5.3", status=API.Status.MAINTAINED)
public final class ConstructorParameterPropertyGenerator
implements PropertyGenerator {
    private final Predicate<Constructor<?>> constructorPredicate;
    private final Matcher matcher;

    public ConstructorParameterPropertyGenerator(Predicate<Constructor<?>> constructorPredicate, Matcher matcher) {
        this.constructorPredicate = constructorPredicate;
        this.matcher = matcher;
    }

    @Override
    public List<Property> generateChildProperties(Property property) {
        Class<?> clazz = Types.getActualType(property.getType());
        Constructor declaredConstructor = TypeCache.getDeclaredConstructors(clazz).stream().filter(this.constructorPredicate).findFirst().orElse(null);
        if (declaredConstructor == null) {
            return Collections.emptyList();
        }
        return this.generateParameterProperties(new ConstructorPropertyGeneratorContext(property, declaredConstructor));
    }

    private static String[] getParameterNames(Constructor<?> constructor) {
        boolean parameterEmpty;
        Parameter[] parameters = constructor.getParameters();
        boolean bl = parameterEmpty = parameters.length == 0;
        if (parameterEmpty) {
            return new String[0];
        }
        ConstructorProperties constructorPropertiesAnnotation = constructor.getAnnotation(ConstructorProperties.class);
        if (constructorPropertiesAnnotation != null) {
            return constructorPropertiesAnnotation.value();
        }
        return (String[])Arrays.stream(parameters).map(Parameter::getName).toArray(String[]::new);
    }

    public List<Property> generateParameterProperties(ConstructorPropertyGeneratorContext context) {
        int parameterStartIndex;
        Property property = context.getProperty();
        Class<?> type = Types.getActualType(property.getType());
        Constructor<?> constructor = context.getConstructor();
        Map<String, AnnotatedType> actualGenericTypesByTypeVariable = ConstructorParameterPropertyGenerator.getGenericAnnotatedTypesByGenericTypeName(property);
        List<String> parameterNamesByConstructor = Arrays.asList(ConstructorParameterPropertyGenerator.getParameterNames(constructor));
        List<String> inputParameterNames = context.getInputParameterNames();
        List<TypeReference<?>> typeReferencesByConstructor = Arrays.stream(constructor.getAnnotatedParameterTypes()).map(it -> actualGenericTypesByTypeVariable.getOrDefault(it.getType().getTypeName(), (AnnotatedType)it)).map(ConstructorParameterPropertyGenerator::toTypeReference).collect(Collectors.toList());
        List<String> resolvedParameterNames = InstantiatorUtils.resolvedParameterNames(parameterNamesByConstructor, inputParameterNames);
        List<TypeReference<?>> resolvedTypeReferences = InstantiatorUtils.resolveParameterTypes(typeReferencesByConstructor, context.getInputParameterTypes());
        Map<String, Field> fieldsByName = TypeCache.getFieldsByName(type);
        boolean anyReceiverParameter = Arrays.stream(constructor.getAnnotatedParameterTypes()).anyMatch(it -> constructor.getAnnotatedReceiverType() != null && it.getType().equals(constructor.getAnnotatedReceiverType().getType()));
        int parameterSize = typeReferencesByConstructor.size();
        LinkedHashMap<String, ConstructorProperty> constructorPropertiesByName = new LinkedHashMap<String, ConstructorProperty>();
        if (anyReceiverParameter) {
            Parameter receiverParameter = constructor.getParameters()[0];
            constructorPropertiesByName.put(receiverParameter.getName(), new ConstructorProperty(receiverParameter.getAnnotatedType(), constructor, receiverParameter.getName(), null, null));
        }
        for (int i = parameterStartIndex = anyReceiverParameter ? 1 : 0; i < parameterSize; ++i) {
            int parameterNameIndex = anyReceiverParameter ? i - 1 : i;
            String parameterName = resolvedParameterNames.get(parameterNameIndex);
            Field field = fieldsByName.get(parameterName);
            FieldProperty fieldProperty = field != null ? new FieldProperty(Types.resolveWithTypeReferenceGenerics(property.getAnnotatedType(), field.getAnnotatedType()), field) : null;
            AnnotatedType parameterAnnotatedType = resolvedTypeReferences.get(i).getAnnotatedType();
            if (ConstructorParameterPropertyGenerator.isGenericAnnotatedType(parameterAnnotatedType) && fieldProperty != null) {
                constructorPropertiesByName.put(parameterName, new ConstructorProperty(fieldProperty.getAnnotatedType(), constructor, parameterName, fieldProperty, null));
                continue;
            }
            constructorPropertiesByName.put(parameterName, new ConstructorProperty(parameterAnnotatedType, constructor, parameterName, fieldProperty, null));
        }
        return constructorPropertiesByName.values().stream().filter(this.matcher::match).collect(Collectors.toList());
    }

    private static TypeReference<Object> toTypeReference(final AnnotatedType annotatedType) {
        return new TypeReference<Object>(){

            @Override
            public Type getType() {
                return annotatedType.getType();
            }

            @Override
            public AnnotatedType getAnnotatedType() {
                return annotatedType;
            }
        };
    }

    private static boolean isGenericAnnotatedType(AnnotatedType annotatedType) {
        return annotatedType instanceof AnnotatedTypeVariable || annotatedType instanceof AnnotatedArrayType;
    }

    private static Map<String, AnnotatedType> getGenericAnnotatedTypesByGenericTypeName(Property property) {
        Class<?> type = Types.getActualType(property.getType());
        List<AnnotatedType> genericsTypes = Types.getGenericsTypes(property.getAnnotatedType());
        List<TypeVariable<Class<?>>> erasedTypeVariables = Arrays.asList(type.getTypeParameters());
        if (genericsTypes.size() != erasedTypeVariables.size()) {
            return Collections.emptyMap();
        }
        HashMap<String, AnnotatedType> actualGenericTypesByTypeName = new HashMap<String, AnnotatedType>();
        for (int i = 0; i < genericsTypes.size(); ++i) {
            AnnotatedType genericType = genericsTypes.get(i);
            TypeVariable<Class<?>> erasedTypeVariable = erasedTypeVariables.get(i);
            actualGenericTypesByTypeName.put(erasedTypeVariable.getName(), genericType);
        }
        return actualGenericTypesByTypeName;
    }
}

