/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.context;

import com.navercorp.fixturemonkey.api.ObjectBuilder;
import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.container.ConcurrentLruCache;
import com.navercorp.fixturemonkey.api.context.MonkeyContextBuilder;
import com.navercorp.fixturemonkey.api.context.MonkeyGeneratorContext;
import com.navercorp.fixturemonkey.api.matcher.MatcherOperator;
import com.navercorp.fixturemonkey.api.option.FixtureMonkeyOptions;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.PropertyPath;
import com.navercorp.fixturemonkey.api.property.RootProperty;
import com.navercorp.fixturemonkey.api.type.Types;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.INTERNAL)
public final class MonkeyContext {
    private final ConcurrentLruCache<Property, CombinableArbitrary<?>> arbitrariesByProperty;
    private final ConcurrentLruCache<Property, CombinableArbitrary<?>> javaArbitrariesByProperty;
    private final ConcurrentLruCache<RootProperty, MonkeyGeneratorContext> generatorContextByRootProperty;
    private final List<MatcherOperator<? extends ObjectBuilder<?>>> registeredArbitraryBuilders;
    private final FixtureMonkeyOptions fixtureMonkeyOptions;

    public MonkeyContext(ConcurrentLruCache<Property, CombinableArbitrary<?>> arbitrariesByProperty, ConcurrentLruCache<Property, CombinableArbitrary<?>> javaArbitrariesByProperty, ConcurrentLruCache<RootProperty, MonkeyGeneratorContext> generatorContextByRootProperty, List<MatcherOperator<? extends ObjectBuilder<?>>> registeredArbitraryBuilders, FixtureMonkeyOptions fixtureMonkeyOptions) {
        this.arbitrariesByProperty = arbitrariesByProperty;
        this.javaArbitrariesByProperty = javaArbitrariesByProperty;
        this.generatorContextByRootProperty = generatorContextByRootProperty;
        this.registeredArbitraryBuilders = registeredArbitraryBuilders;
        this.fixtureMonkeyOptions = fixtureMonkeyOptions;
    }

    public static MonkeyContextBuilder builder(FixtureMonkeyOptions fixtureMonkeyOptions) {
        return new MonkeyContextBuilder(fixtureMonkeyOptions);
    }

    public CombinableArbitrary<?> getCachedArbitrary(Property property) {
        CombinableArbitrary<?> javaTypeCombinableArbitrary = this.javaArbitrariesByProperty.get(property);
        if (javaTypeCombinableArbitrary != null) {
            return javaTypeCombinableArbitrary;
        }
        return this.arbitrariesByProperty.get(property);
    }

    public void putCachedArbitrary(Property property, CombinableArbitrary<?> combinableArbitrary) {
        Class<?> type = Types.getActualType(property.getType());
        if (Types.isJavaType(type)) {
            this.javaArbitrariesByProperty.putIfAbsent(property, combinableArbitrary);
            return;
        }
        this.arbitrariesByProperty.put(property, combinableArbitrary);
    }

    public MonkeyGeneratorContext newGeneratorContext(RootProperty rootProperty) {
        return this.generatorContextByRootProperty.computeIfAbsent(rootProperty, property -> new MonkeyGeneratorContext(new TreeMap<PropertyPath, Set<Object>>()));
    }

    public List<MatcherOperator<? extends ObjectBuilder<?>>> getRegisteredArbitraryBuilders() {
        return this.registeredArbitraryBuilders;
    }

    public FixtureMonkeyOptions getFixtureMonkeyOptions() {
        return this.fixtureMonkeyOptions;
    }
}

