/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.expression;

import com.navercorp.fixturemonkey.api.type.TypeCache;
import javax.annotation.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JavaGetterPropertyFieldNameResolver {
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";

    @Nullable
    public String resolveFieldName(Class<?> targetClass, String methodName) {
        if (JavaGetterPropertyFieldNameResolver.hasPrefix(GET_PREFIX, methodName)) {
            return JavaGetterPropertyFieldNameResolver.stripPrefixPropertyName(targetClass, methodName, GET_PREFIX.length());
        }
        if (JavaGetterPropertyFieldNameResolver.hasPrefix(IS_PREFIX, methodName)) {
            return JavaGetterPropertyFieldNameResolver.stripPrefixPropertyName(targetClass, methodName, IS_PREFIX.length());
        }
        if (JavaGetterPropertyFieldNameResolver.isValidField(targetClass, methodName)) {
            return methodName;
        }
        return null;
    }

    private static String stripPrefixPropertyName(Class<?> targetClass, String methodName, int prefixLength) {
        char[] ch = methodName.toCharArray();
        ch[prefixLength] = Character.toLowerCase(ch[prefixLength]);
        String fieldName = new String(ch, prefixLength, ch.length - prefixLength);
        return JavaGetterPropertyFieldNameResolver.isValidField(targetClass, fieldName) ? fieldName : null;
    }

    private static boolean hasPrefix(String prefix, String methodName) {
        return methodName.startsWith(prefix) && methodName.length() > prefix.length();
    }

    private static boolean isValidField(Class<?> type, String fieldName) {
        return TypeCache.getFieldsByName(type).containsKey(fieldName);
    }
}

