/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class ElementProperty
implements Property {
    private final Property containerProperty;
    private final AnnotatedType elementType;
    @Nullable
    private final Integer index;
    private final int sequence;
    private final List<Annotation> annotations;
    private final Map<Class<? extends Annotation>, Annotation> annotationsMap;

    public ElementProperty(Property containerProperty, AnnotatedType elementType, @Nullable Integer index, int sequence) {
        this.containerProperty = containerProperty;
        this.elementType = elementType;
        this.index = index;
        this.sequence = sequence;
        this.annotations = Arrays.asList(this.elementType.getAnnotations());
        this.annotationsMap = this.annotations.stream().collect(Collectors.toMap(Annotation::annotationType, Function.identity(), (a1, a2) -> a1));
    }

    @Override
    public Type getType() {
        return this.getAnnotatedType().getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.elementType;
    }

    public Property getContainerProperty() {
        return this.containerProperty;
    }

    public AnnotatedType getElementType() {
        return this.elementType;
    }

    @Nullable
    public Integer getIndex() {
        return this.index;
    }

    public int getSequence() {
        return this.sequence;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationClass) {
        return Optional.ofNullable(this.annotationsMap.get(annotationClass)).map(annotationClass::cast);
    }

    @Override
    @Nullable
    public Object getValue(Object instance) {
        Class<?> actualType = Types.getActualType(instance.getClass());
        if (this.isOptional(actualType)) {
            return this.getOptionalValue(instance);
        }
        if (actualType.isArray()) {
            if (Array.getLength(instance) == 0) {
                return null;
            }
            return Array.get(instance, this.sequence);
        }
        if (List.class.isAssignableFrom(actualType)) {
            List list = (List)instance;
            if (list.isEmpty()) {
                return null;
            }
            return list.get(this.sequence);
        }
        if (Supplier.class.isAssignableFrom(actualType)) {
            return instance;
        }
        throw new IllegalArgumentException("given element value has no match sequence : " + this.sequence);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ElementProperty that = (ElementProperty)obj;
        return this.containerProperty.equals(that.containerProperty) && this.elementType.getType().equals(that.elementType.getType()) && this.annotations.equals(that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.containerProperty, this.elementType.getType(), this.annotations);
    }

    private boolean isOptional(Class<?> type) {
        return Optional.class.isAssignableFrom(type) || OptionalInt.class.isAssignableFrom(type) || OptionalLong.class.isAssignableFrom(type) || OptionalDouble.class.isAssignableFrom(type);
    }

    @Nullable
    private Object getOptionalValue(Object obj) {
        Class<?> actualType = Types.getActualType(obj.getClass());
        if (Optional.class.isAssignableFrom(actualType)) {
            return ((Optional)obj).orElse(null);
        }
        if (OptionalInt.class.isAssignableFrom(actualType)) {
            return ((OptionalInt)obj).orElse(0);
        }
        if (OptionalLong.class.isAssignableFrom(actualType)) {
            return ((OptionalLong)obj).orElse(0L);
        }
        if (OptionalDouble.class.isAssignableFrom(actualType)) {
            return ((OptionalDouble)obj).orElse(Double.NaN);
        }
        throw new IllegalArgumentException("given value is not optional, actual type : " + actualType);
    }
}

