/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class MapKeyElementProperty
implements Property {
    private final Property mapProperty;
    private final AnnotatedType keyType;
    private final int sequence;
    private final List<Annotation> annotations;

    public MapKeyElementProperty(Property mapProperty, AnnotatedType keyType, int sequence) {
        this.mapProperty = mapProperty;
        this.keyType = keyType;
        this.sequence = sequence;
        this.annotations = Arrays.asList(this.keyType.getAnnotations());
    }

    @Override
    public Type getType() {
        return this.getAnnotatedType().getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.keyType;
    }

    public Property getMapProperty() {
        return this.mapProperty;
    }

    public AnnotatedType getKeyType() {
        return this.keyType;
    }

    public int getSequence() {
        return this.sequence;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Boolean isNullable() {
        return false;
    }

    @Override
    @Nullable
    public Object getValue(Object instance) {
        Class<?> actualType = Types.getActualType(instance.getClass());
        if (Map.class.isAssignableFrom(actualType)) {
            Map map = (Map)instance;
            Iterator iterator = map.entrySet().iterator();
            int iteratorSequence = 0;
            while (iterator.hasNext()) {
                Map.Entry value = iterator.next();
                if (iteratorSequence == this.getSequence()) {
                    return value.getKey();
                }
                ++iteratorSequence;
            }
        }
        if (Map.Entry.class.isAssignableFrom(actualType)) {
            Map.Entry entry = (Map.Entry)instance;
            return entry.getKey();
        }
        throw new IllegalArgumentException("given value is not Map Entry. " + instance.getClass());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MapKeyElementProperty that = (MapKeyElementProperty)obj;
        return this.mapProperty.equals(that.mapProperty) && this.keyType.getType().equals(that.keyType.getType()) && this.annotations.equals(that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.mapProperty, this.keyType.getType(), this.annotations);
    }
}

