/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.property;

import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="0.4.0", status=API.Status.MAINTAINED)
public final class MapValueElementProperty
implements Property {
    private final Property mapProperty;
    private final AnnotatedType valueType;
    private final int sequence;
    private final List<Annotation> annotations;

    public MapValueElementProperty(Property mapProperty, AnnotatedType valueType, int sequence) {
        this.mapProperty = mapProperty;
        this.valueType = valueType;
        this.sequence = sequence;
        this.annotations = Arrays.asList(this.valueType.getAnnotations());
    }

    @Override
    public Type getType() {
        return this.getAnnotatedType().getType();
    }

    @Override
    public AnnotatedType getAnnotatedType() {
        return this.valueType;
    }

    public Property getMapProperty() {
        return this.mapProperty;
    }

    public AnnotatedType getValueType() {
        return this.valueType;
    }

    public int getSequence() {
        return this.sequence;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    @Nullable
    public Object getValue(Object instance) {
        Class<?> actualType = Types.getActualType(instance.getClass());
        if (Map.class.isAssignableFrom(actualType)) {
            Map map = (Map)instance;
            Iterator iterator = map.entrySet().iterator();
            int iteratorSequence = 0;
            while (iterator.hasNext()) {
                Map.Entry value = iterator.next();
                if (iteratorSequence == this.getSequence()) {
                    return value.getValue();
                }
                ++iteratorSequence;
            }
        }
        if (Map.Entry.class.isAssignableFrom(actualType)) {
            Map.Entry entry = (Map.Entry)instance;
            return entry.getValue();
        }
        throw new IllegalArgumentException("given value is not Map Entry. " + instance.getClass());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MapValueElementProperty that = (MapValueElementProperty)obj;
        return this.mapProperty.equals(that.mapProperty) && this.valueType.getType().equals(that.valueType.getType()) && this.annotations.equals(that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.mapProperty, this.valueType.getType(), this.annotations);
    }
}

