/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.type;

import com.navercorp.fixturemonkey.api.container.ConcurrentLruCache;
import java.lang.annotation.Annotation;
import javax.annotation.Nullable;
import org.apiguardian.api.API;

@API(since="1.0.0", status=API.Status.INTERNAL)
public abstract class KotlinTypeDetector {
    @Nullable
    private static final Class<? extends Annotation> kotlinMetadata;
    private static final ConcurrentLruCache<Class<?>, Boolean> IS_KOTLIN_TYPE;

    public static boolean isKotlinType(Class<?> clazz) {
        return IS_KOTLIN_TYPE.computeIfAbsent(clazz, type -> kotlinMetadata != null && type.getDeclaredAnnotation(kotlinMetadata) != null);
    }

    static {
        Class<?> metadata;
        IS_KOTLIN_TYPE = new ConcurrentLruCache(2048);
        ClassLoader classLoader = KotlinTypeDetector.class.getClassLoader();
        try {
            metadata = Class.forName("kotlin.Metadata", false, classLoader);
        }
        catch (ClassNotFoundException ex) {
            metadata = null;
        }
        kotlinMetadata = metadata;
    }
}

