/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.arbitrary;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.exception.FixedValueFilterMissException;
import com.navercorp.fixturemonkey.api.exception.RetryableFilterMissException;
import com.navercorp.fixturemonkey.api.exception.ValidationFailedException;
import com.navercorp.fixturemonkey.api.property.PropertyPath;
import com.navercorp.fixturemonkey.api.property.Traceable;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jqwik.api.TooManyFilterMissesException;
import org.apiguardian.api.API;

@API(since="0.5.0", status=API.Status.MAINTAINED)
final class FilteredCombinableArbitrary<T>
implements CombinableArbitrary<T> {
    private final int maxMisses;
    private final CombinableArbitrary<T> combinableArbitrary;
    private final Predicate<T> predicate;
    private Exception lastException;

    FilteredCombinableArbitrary(int maxMisses, CombinableArbitrary<T> combinableArbitrary, Predicate<T> predicate) {
        this.maxMisses = maxMisses;
        this.combinableArbitrary = combinableArbitrary;
        this.predicate = predicate;
    }

    FilteredCombinableArbitrary(int maxMisses, FilteredCombinableArbitrary<T> filteredCombinableArbitrary, Predicate<T> predicate) {
        this.maxMisses = maxMisses;
        this.combinableArbitrary = filteredCombinableArbitrary.combinableArbitrary;
        this.predicate = predicate.and(filteredCombinableArbitrary.predicate);
    }

    @Override
    public T combined() {
        for (int i = 0; i < this.maxMisses; ++i) {
            try {
                T returned = this.combinableArbitrary.combined();
                if (this.predicate.test(returned)) {
                    return returned;
                }
                if (!this.fixed()) continue;
                throw new FixedValueFilterMissException("Fixed value can not satisfy given filter.");
            }
            catch (RetryableFilterMissException | ValidationFailedException | TooManyFilterMissesException ex) {
                if (this.lastException == null || ex.getCause() != null) {
                    this.lastException = ex;
                }
                this.combinableArbitrary.clear();
            }
        }
        if (this.lastException == null && this.combinableArbitrary instanceof FilteredCombinableArbitrary) {
            this.lastException = ((FilteredCombinableArbitrary)this.combinableArbitrary).lastException;
        }
        if (this.lastException instanceof ValidationFailedException) {
            String failedConcatProperties = String.join((CharSequence)", ", ((ValidationFailedException)this.lastException).getConstraintViolationPropertyNames());
            throw new RetryableFilterMissException(String.format("Given properties \"%s\" is not validated by annotations.", failedConcatProperties), this.lastException);
        }
        if (this.lastException != null) {
            throw this.newRetryableFilterMissException(this.lastException);
        }
        if (this.combinableArbitrary instanceof Traceable) {
            PropertyPath propertyPath = ((Traceable)((Object)this.combinableArbitrary)).getPropertyPath();
            String generateType = propertyPath.getProperty().getType().getTypeName();
            String expression = "".equals(propertyPath.getExpression()) ? "$" : propertyPath.getExpression();
            throw new RetryableFilterMissException(String.format("Generate type \"%s\" is failed due to property \"%s\".", generateType, expression), this.lastException);
        }
        throw this.newRetryableFilterMissException(this.lastException);
    }

    @Override
    public T rawValue() {
        for (int i = 0; i < this.maxMisses; ++i) {
            try {
                Object returned = this.combinableArbitrary.rawValue();
                if (this.predicate.test(returned)) {
                    return (T)returned;
                }
                if (!this.fixed()) continue;
                throw new FixedValueFilterMissException("Fixed value can not satisfy given filter.");
            }
            catch (RetryableFilterMissException | ValidationFailedException | TooManyFilterMissesException ex) {
                if (this.lastException == null || ex.getCause() != null) {
                    this.lastException = ex;
                }
                this.combinableArbitrary.clear();
                continue;
            }
            catch (ClassCastException ex) {
                throw new ClassCastException(String.format("Filtering is failed due to %s. Please check if given value is well deserialized.", ex.getMessage()));
            }
        }
        if (this.lastException == null && this.combinableArbitrary instanceof FilteredCombinableArbitrary) {
            this.lastException = ((FilteredCombinableArbitrary)this.combinableArbitrary).lastException;
        }
        if (this.lastException instanceof ValidationFailedException) {
            String failedConcatProperties = String.join((CharSequence)", ", ((ValidationFailedException)this.lastException).getConstraintViolationPropertyNames());
            throw new RetryableFilterMissException(String.format("Given properties \"%s\" is not validated by annotations.", failedConcatProperties), this.lastException);
        }
        if (this.lastException != null) {
            throw this.newRetryableFilterMissException(this.lastException);
        }
        if (this.combinableArbitrary instanceof Traceable) {
            PropertyPath propertyPath = ((Traceable)((Object)this.combinableArbitrary)).getPropertyPath();
            String generateType = propertyPath.getProperty().getType().getTypeName();
            String expression = "".equals(propertyPath.getExpression()) ? "$" : propertyPath.getExpression();
            throw new RetryableFilterMissException(String.format("Generate type \"%s\" is failed due to property \"%s\".", generateType, expression), this.lastException);
        }
        throw this.newRetryableFilterMissException(this.lastException);
    }

    @Override
    public void clear() {
        this.combinableArbitrary.clear();
    }

    @Override
    public boolean fixed() {
        return this.combinableArbitrary.fixed();
    }

    @Override
    public CombinableArbitrary<T> unique() {
        return this.combinableArbitrary.unique();
    }

    private RetryableFilterMissException newRetryableFilterMissException(@Nullable Throwable throwable) {
        if (!(throwable instanceof RetryableFilterMissException)) {
            return new RetryableFilterMissException(throwable);
        }
        return (RetryableFilterMissException)throwable;
    }
}

