/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.arbitrary;

import com.navercorp.fixturemonkey.api.jqwik.ArbitraryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.arbitraries.CharacterArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.engine.properties.arbitraries.DefaultCharacterArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableString;
import org.apiguardian.api.API;

@API(since="0.6.0", status=API.Status.MAINTAINED)
public final class MonkeyStringArbitrary
implements StringArbitrary {
    private CharacterArbitrary characterArbitrary = new DefaultCharacterArbitrary();
    private int minLength = 0;
    private Integer maxLength = null;
    private Predicate<Character> filter = c -> true;
    private RandomDistribution lengthDistribution = null;
    private double repeatChars = 0.0;

    public RandomGenerator<String> generator(int genSize) {
        long maxUniqueChars = this.characterArbitrary.exhaustive((long)this.maxLength()).map(ExhaustiveGenerator::maxCount).orElse(Long.valueOf(this.maxLength()));
        return RandomGenerators.strings(this.randomCharacterGenerator(), (int)this.minLength, (int)this.maxLength(), (long)maxUniqueChars, (int)genSize, (RandomDistribution)this.lengthDistribution, ArbitraryUtils.newThreadSafeArbitrary(this.characterArbitrary));
    }

    public RandomGenerator<String> generator(int genSize, boolean withEdgeCases) {
        return this.generator(genSize);
    }

    private int maxLength() {
        return RandomGenerators.collectionMaxSize((int)this.minLength, (Integer)this.maxLength);
    }

    public Optional<ExhaustiveGenerator<String>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.strings(this.effectiveCharacterArbitrary(), (int)this.minLength, (int)this.maxLength(), (long)maxNumberOfSamples);
    }

    public EdgeCases<String> edgeCases(int maxEdgeCases) {
        if (maxEdgeCases <= 0) {
            return EdgeCases.none();
        }
        EdgeCases<String> emptyStringEdgeCases = this.hasEmptyStringEdgeCase() ? this.emptyStringEdgeCase() : EdgeCases.none();
        int effectiveMaxEdgeCases = maxEdgeCases - emptyStringEdgeCases.size();
        EdgeCases<String> singleCharEdgeCases = this.hasSingleCharEdgeCases() ? this.fixedSizedEdgeCases(1, effectiveMaxEdgeCases) : EdgeCases.none();
        EdgeCases<String> fixedSizeEdgeCases = this.hasMultiCharEdgeCases() ? this.fixedSizedEdgeCases(this.minLength, effectiveMaxEdgeCases -= singleCharEdgeCases.size()) : EdgeCases.none();
        return EdgeCasesSupport.concat(Arrays.asList(singleCharEdgeCases, emptyStringEdgeCases, fixedSizeEdgeCases), (int)maxEdgeCases);
    }

    private boolean hasEmptyStringEdgeCase() {
        return this.minLength <= 0;
    }

    private boolean hasMultiCharEdgeCases() {
        return this.minLength <= this.maxLength() && this.minLength > 1;
    }

    private boolean hasSingleCharEdgeCases() {
        return this.minLength <= 1 && this.maxLength() >= 1;
    }

    private EdgeCases<String> emptyStringEdgeCase() {
        return EdgeCases.fromSupplier(() -> new ShrinkableString(Collections.emptyList(), this.minLength, this.maxLength(), (Arbitrary)this.characterArbitrary));
    }

    private EdgeCases<String> fixedSizedEdgeCases(int fixedSize, int maxEdgeCases) {
        return EdgeCasesSupport.mapShrinkable((EdgeCases)this.effectiveCharacterArbitrary().edgeCases(maxEdgeCases), shrinkableChar -> {
            ArrayList<Shrinkable> shrinkableChars = new ArrayList<Shrinkable>(Collections.nCopies(fixedSize, shrinkableChar));
            return new ShrinkableString(shrinkableChars, this.minLength, this.maxLength(), (Arbitrary)this.characterArbitrary);
        });
    }

    public StringArbitrary ofMinLength(int minLength) {
        if (minLength < 0) {
            String message = String.format("minLength (%s) must be between 0 and 2147483647", minLength);
            throw new IllegalArgumentException(message);
        }
        this.minLength = minLength;
        return this;
    }

    public StringArbitrary ofMaxLength(int maxLength) {
        if (maxLength < 0) {
            String message = String.format("maxLength (%s) must be between 0 and 2147483647", maxLength);
            throw new IllegalArgumentException(message);
        }
        if (maxLength < this.minLength) {
            String message = String.format("minLength (%s) must not be larger than maxLength (%s)", this.minLength, maxLength);
            throw new IllegalArgumentException(message);
        }
        this.maxLength = maxLength;
        return this;
    }

    public StringArbitrary withLengthDistribution(RandomDistribution distribution) {
        this.lengthDistribution = distribution;
        return this;
    }

    public StringArbitrary repeatChars(double repeatProbability) {
        if (repeatProbability < 0.0 || repeatProbability >= 1.0) {
            throw new IllegalArgumentException("repeatProbability must be between 0 (included) and 1 (excluded)");
        }
        this.repeatChars = repeatProbability;
        return this;
    }

    public StringArbitrary withChars(char ... chars) {
        this.characterArbitrary = this.characterArbitrary.with(chars);
        return this;
    }

    public StringArbitrary withChars(CharSequence chars) {
        this.characterArbitrary = this.characterArbitrary.with(chars);
        return this;
    }

    public StringArbitrary withCharRange(char from, char to) {
        this.characterArbitrary = this.characterArbitrary.range(from, to);
        return this;
    }

    public StringArbitrary ascii() {
        this.characterArbitrary = this.characterArbitrary.ascii();
        return this;
    }

    public StringArbitrary alpha() {
        this.characterArbitrary = this.characterArbitrary.alpha();
        return this;
    }

    public StringArbitrary korean() {
        this.characterArbitrary = this.characterArbitrary.range('\uac00', '\ud7a3');
        return this;
    }

    public StringArbitrary numeric() {
        this.characterArbitrary = this.characterArbitrary.numeric();
        return this;
    }

    public StringArbitrary whitespace() {
        this.characterArbitrary = this.characterArbitrary.whitespace();
        return this;
    }

    public StringArbitrary all() {
        return this.withCharRange('\u0000', '\uffff');
    }

    public StringArbitrary excludeChars(char ... charsToExclude) {
        LinkedHashSet<Character> excludedChars = new LinkedHashSet<Character>();
        for (char c2 : charsToExclude) {
            excludedChars.add(Character.valueOf(c2));
        }
        this.filterCharacter(c -> !excludedChars.contains(c));
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MonkeyStringArbitrary that = (MonkeyStringArbitrary)obj;
        if (this.minLength != that.minLength) {
            return false;
        }
        if (!Objects.equals(this.maxLength, that.maxLength)) {
            return false;
        }
        if (Double.compare(that.repeatChars, this.repeatChars) != 0) {
            return false;
        }
        if (!this.characterArbitrary.equals(that.characterArbitrary)) {
            return false;
        }
        if (!this.filter.equals(that.filter)) {
            return false;
        }
        return Objects.equals(this.lengthDistribution, that.lengthDistribution);
    }

    public int hashCode() {
        return HashCodeSupport.hash((Object)this.characterArbitrary, (Object)this.minLength, (Object)this.maxLength, (Object)this.repeatChars, this.filter, (Object)this.lengthDistribution);
    }

    public MonkeyStringArbitrary filterCharacter(Predicate<Character> predicate) {
        this.filter = this.filter.and(predicate);
        return this;
    }

    private RandomGenerator<Character> randomCharacterGenerator() {
        RandomGenerator characterGenerator = this.effectiveCharacterArbitrary().generator(1, false);
        if (this.repeatChars > 0.0) {
            return characterGenerator.injectDuplicates(this.repeatChars);
        }
        return characterGenerator;
    }

    private Arbitrary<Character> effectiveCharacterArbitrary() {
        CharacterArbitrary characterArbitrary = this.characterArbitrary;
        return ArbitraryUtils.newThreadSafeArbitrary(characterArbitrary.filter(this.filter));
    }
}

