/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.arbitrary;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.generator.ArbitraryProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apiguardian.api.API;

@API(since="0.6.0", status=API.Status.MAINTAINED)
final class ObjectCombinableArbitrary<T>
implements CombinableArbitrary<T> {
    private final Map<ArbitraryProperty, CombinableArbitrary<?>> combinableArbitrariesByArbitraryProperty;
    private final Function<Map<ArbitraryProperty, Object>, T> combinator;

    ObjectCombinableArbitrary(Map<ArbitraryProperty, CombinableArbitrary<?>> combinableArbitrariesByArbitraryProperty, Function<Map<ArbitraryProperty, Object>, T> combinator) {
        this.combinableArbitrariesByArbitraryProperty = combinableArbitrariesByArbitraryProperty;
        this.combinator = combinator;
    }

    @Override
    public T combined() {
        HashMap combinedPropertyValuesByArbitraryProperty = new HashMap();
        this.combinableArbitrariesByArbitraryProperty.forEach((key, value) -> combinedPropertyValuesByArbitraryProperty.put(key, value.combined()));
        return this.combinator.apply(combinedPropertyValuesByArbitraryProperty);
    }

    @Override
    public Object rawValue() {
        HashMap rawPropertyValuesByArbitraryProperty = new HashMap();
        this.combinableArbitrariesByArbitraryProperty.forEach((key, value) -> rawPropertyValuesByArbitraryProperty.put(key, value.rawValue()));
        return this.combinator.apply(rawPropertyValuesByArbitraryProperty);
    }

    @Override
    public void clear() {
        this.combinableArbitrariesByArbitraryProperty.forEach((property, arbitrary) -> {
            if (!arbitrary.fixed()) {
                arbitrary.clear();
            }
        });
    }

    @Override
    public boolean fixed() {
        return this.combinableArbitrariesByArbitraryProperty.values().stream().allMatch(CombinableArbitrary::fixed);
    }
}

