/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.arbitrary;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import java.util.Map;
import org.apiguardian.api.API;

@API(since="0.6.0", status=API.Status.MAINTAINED)
final class UniqueCombinableArbitrary<T>
implements CombinableArbitrary<T> {
    private static final Object EXISTED = new Object();
    private final CombinableArbitrary<T> combinableArbitrary;
    private final Map<Object, Object> generated;

    UniqueCombinableArbitrary(CombinableArbitrary<T> combinableArbitrary, Map<Object, Object> generated) {
        this.combinableArbitrary = combinableArbitrary;
        this.generated = generated;
    }

    @Override
    public T combined() {
        return (T)this.combinableArbitrary.filter(it -> {
            if (!this.generated.containsKey(it)) {
                this.generated.put(it, EXISTED);
                return true;
            }
            return false;
        }).combined();
    }

    @Override
    public Object rawValue() {
        return this.combinableArbitrary.filter(it -> {
            if (!this.generated.containsKey(it)) {
                this.generated.put(it, EXISTED);
                return true;
            }
            return false;
        }).rawValue();
    }

    @Override
    public void clear() {
        this.combinableArbitrary.clear();
    }

    @Override
    public boolean fixed() {
        return this.combinableArbitrary.fixed();
    }
}

