/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.container;

import com.navercorp.fixturemonkey.api.container.LruCache;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apiguardian.api.API;

@API(since="0.5.10", status=API.Status.MAINTAINED)
public final class ConcurrentLruCache<K, V>
implements Map<K, V> {
    private final Map<K, V> lruCache;

    public ConcurrentLruCache(int maxSize) {
        this.lruCache = Collections.synchronizedMap(new LruCache(maxSize));
    }

    @Override
    public int size() {
        return this.lruCache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.lruCache.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.lruCache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.lruCache.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.lruCache.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.lruCache.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.lruCache.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.lruCache.putAll(map);
    }

    @Override
    public void clear() {
        this.lruCache.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.lruCache.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.lruCache.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.lruCache.entrySet();
    }
}

