/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.generator.ArbitraryContainerInfo;
import com.navercorp.fixturemonkey.api.generator.ContainerProperty;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGenerator;
import com.navercorp.fixturemonkey.api.generator.ContainerPropertyGeneratorContext;
import com.navercorp.fixturemonkey.api.property.Property;
import com.navercorp.fixturemonkey.api.property.SingleElementProperty;
import com.navercorp.fixturemonkey.api.property.TypeParameterProperty;
import com.navercorp.fixturemonkey.api.type.Types;
import java.lang.reflect.AnnotatedType;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;

@API(since="1.0.21", status=API.Status.EXPERIMENTAL)
public final class FunctionalInterfaceContainerPropertyGenerator
implements ContainerPropertyGenerator {
    public static final FunctionalInterfaceContainerPropertyGenerator INSTANCE = new FunctionalInterfaceContainerPropertyGenerator();
    private static final ArbitraryContainerInfo CONTAINER_INFO = new ArbitraryContainerInfo(1, 1);

    @Override
    public ContainerProperty generate(ContainerPropertyGeneratorContext context) {
        Property property = context.getProperty();
        AnnotatedType lambdaReturnAnnotatedType = this.getLambdaReturnAnnotatedType(property);
        SingleElementProperty singleElementProperty = new SingleElementProperty(property, new TypeParameterProperty(lambdaReturnAnnotatedType));
        return new ContainerProperty(Collections.singletonList(singleElementProperty), CONTAINER_INFO);
    }

    private AnnotatedType getLambdaReturnAnnotatedType(Property lambdaProperty) {
        List<AnnotatedType> genericsTypes = Types.getGenericsTypes(lambdaProperty.getAnnotatedType());
        return genericsTypes.get(genericsTypes.size() - 1);
    }
}

