/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.fixturemonkey.api.generator;

import com.navercorp.fixturemonkey.api.arbitrary.CombinableArbitrary;
import com.navercorp.fixturemonkey.api.constraint.JavaConstraintGenerator;
import com.navercorp.fixturemonkey.api.constraint.JavaContainerConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaDateTimeConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaDecimalConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaIntegerConstraint;
import com.navercorp.fixturemonkey.api.constraint.JavaStringConstraint;
import com.navercorp.fixturemonkey.api.container.DecomposableJavaContainer;
import com.navercorp.fixturemonkey.api.container.DecomposedContainerValueFactory;
import com.navercorp.fixturemonkey.api.exception.ContainerSizeFilterMissException;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGenerator;
import com.navercorp.fixturemonkey.api.generator.ArbitraryGeneratorContext;
import com.navercorp.fixturemonkey.api.type.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.apiguardian.api.API;

@API(since="0.6.9", status=API.Status.MAINTAINED)
public final class ValidateArbitraryGenerator
implements ArbitraryGenerator {
    private static final ZoneOffset ZONE_OFFSET = OffsetTime.now().getOffset();
    private final JavaConstraintGenerator constraintGenerator;
    private final DecomposedContainerValueFactory decomposedContainerValueFactory;

    public ValidateArbitraryGenerator(JavaConstraintGenerator constraintGenerator, DecomposedContainerValueFactory decomposedContainerValueFactory) {
        this.constraintGenerator = constraintGenerator;
        this.decomposedContainerValueFactory = decomposedContainerValueFactory;
    }

    @Override
    public CombinableArbitrary<?> generate(ArbitraryGeneratorContext context) {
        JavaContainerConstraint javaContainerConstraint;
        JavaIntegerConstraint javaIntegerConstraint;
        JavaDateTimeConstraint javaDateConstraint;
        JavaDateTimeConstraint javaDateTimeConstraint;
        JavaDecimalConstraint javaDecimalConstraint;
        JavaStringConstraint javaStringConstraint;
        CombinableArbitrary<Object> generated = context.getGenerated();
        if (generated == CombinableArbitrary.NOT_GENERATED) {
            return CombinableArbitrary.NOT_GENERATED;
        }
        Class<?> type = Types.getActualType(context.getResolvedType());
        if (type == String.class && (javaStringConstraint = this.constraintGenerator.generateStringConstraint(context)) != null) {
            generated = generated.filter(it -> {
                String string = (String)it;
                if (javaStringConstraint.isNotNull() && string == null) {
                    return false;
                }
                if (javaStringConstraint.isNotBlank()) {
                    if (string == null) {
                        return false;
                    }
                    return !this.isBlank(string);
                }
                if (javaStringConstraint.getMinSize() != null) {
                    if (string == null) {
                        return true;
                    }
                    return BigInteger.valueOf(string.length()).compareTo(javaStringConstraint.getMinSize()) >= 0;
                }
                if (javaStringConstraint.getMaxSize() != null) {
                    if (string == null) {
                        return true;
                    }
                    return BigInteger.valueOf(string.length()).compareTo(javaStringConstraint.getMaxSize()) <= 0;
                }
                return true;
            });
        }
        if (Types.isDecimalType(type) && (javaDecimalConstraint = this.constraintGenerator.generateDecimalConstraint(context)) != null) {
            generated = generated.filter(it -> {
                if (it == null) {
                    return true;
                }
                BigDecimal value = this.toBigDecimal(it);
                if (value.compareTo(BigDecimal.ZERO) < 0) {
                    if (javaDecimalConstraint.getNegativeMin() != null) {
                        if (value.compareTo(javaDecimalConstraint.getNegativeMin()) == 0 && Boolean.FALSE.equals(javaDecimalConstraint.getNegativeMinInclusive())) {
                            return false;
                        }
                        if (value.compareTo(javaDecimalConstraint.getNegativeMin()) < 0) {
                            return false;
                        }
                    }
                    if (javaDecimalConstraint.getNegativeMax() != null) {
                        if (value.compareTo(javaDecimalConstraint.getNegativeMax()) == 0 && Boolean.FALSE.equals(javaDecimalConstraint.getNegativeMaxInclusive())) {
                            return false;
                        }
                        if (value.compareTo(javaDecimalConstraint.getNegativeMax()) > 0) {
                            return false;
                        }
                    }
                }
                if (value.compareTo(BigDecimal.ZERO) > 0) {
                    if (javaDecimalConstraint.getPositiveMin() != null) {
                        if (value.compareTo(javaDecimalConstraint.getPositiveMin()) == 0 && Boolean.FALSE.equals(javaDecimalConstraint.getPositiveMinInclusive())) {
                            return false;
                        }
                        if (value.compareTo(javaDecimalConstraint.getPositiveMin()) < 0) {
                            return false;
                        }
                    }
                    if (javaDecimalConstraint.getPositiveMax() != null) {
                        if (value.compareTo(javaDecimalConstraint.getPositiveMax()) == 0 && Boolean.FALSE.equals(javaDecimalConstraint.getPositiveMaxInclusive())) {
                            return false;
                        }
                        if (value.compareTo(javaDecimalConstraint.getPositiveMax()) > 0) {
                            return false;
                        }
                    }
                }
                return true;
            });
        }
        if (Types.isTimeType(type) && (javaDateTimeConstraint = this.constraintGenerator.generateDateTimeConstraint(context)) != null) {
            generated = generated.filter(it -> {
                if (it == null) {
                    return true;
                }
                OffsetTime offsetTime = this.toOffsetTime(it);
                if (javaDateTimeConstraint.getMin() != null && offsetTime.isBefore(javaDateTimeConstraint.getMin().atOffset(ZONE_OFFSET).toOffsetTime())) {
                    return false;
                }
                return javaDateTimeConstraint.getMax() == null || !offsetTime.isAfter(javaDateTimeConstraint.getMax().atOffset(ZONE_OFFSET).toOffsetTime());
            });
        }
        if (Types.isDateTimeType(type) && (javaDateTimeConstraint = this.constraintGenerator.generateDateTimeConstraint(context)) != null) {
            generated = generated.filter(it -> {
                if (it == null) {
                    return true;
                }
                LocalDateTime localDateTime = this.toLocalDateTime(it);
                if (javaDateTimeConstraint.getMin() != null && localDateTime.isBefore(javaDateTimeConstraint.getMin())) {
                    return false;
                }
                return javaDateTimeConstraint.getMax() == null || !localDateTime.isAfter(javaDateTimeConstraint.getMax());
            });
        }
        if (Types.isDateType(type) && (javaDateConstraint = this.constraintGenerator.generateDateTimeConstraint(context)) != null) {
            generated = generated.filter(it -> {
                if (it == null) {
                    return true;
                }
                LocalDate localDate = this.toLocalDate(it);
                if (javaDateConstraint.getMin() != null && !localDate.isAfter(javaDateConstraint.getMin().toLocalDate())) {
                    return false;
                }
                return javaDateConstraint.getMax() == null || localDate.isBefore(javaDateConstraint.getMax().toLocalDate());
            });
        }
        if (Types.isIntegerType(type) && (javaIntegerConstraint = this.constraintGenerator.generateIntegerConstraint(context)) != null) {
            generated = generated.filter(it -> {
                if (it == null) {
                    return true;
                }
                BigInteger value = this.toBigInteger(it);
                if (value.compareTo(BigInteger.ZERO) < 0) {
                    if (javaIntegerConstraint.getNegativeMin() != null && value.compareTo(javaIntegerConstraint.getNegativeMin()) < 0) {
                        return false;
                    }
                    if (javaIntegerConstraint.getNegativeMax() != null && value.compareTo(BigInteger.ZERO) < 0 && value.compareTo(javaIntegerConstraint.getNegativeMax()) > 0) {
                        return false;
                    }
                }
                if (value.compareTo(BigInteger.ZERO) > 0) {
                    if (javaIntegerConstraint.getPositiveMin() != null && value.compareTo(javaIntegerConstraint.getPositiveMin()) < 0) {
                        return false;
                    }
                    if (javaIntegerConstraint.getPositiveMax() != null && value.compareTo(javaIntegerConstraint.getPositiveMax()) > 0) {
                        return false;
                    }
                }
                return true;
            });
        }
        if (context.getArbitraryProperty().isContainer() && (javaContainerConstraint = this.constraintGenerator.generateContainerConstraint(context)) != null) {
            generated = generated.filter(it -> {
                DecomposableJavaContainer decomposableJavaContainer;
                if (it == null) {
                    return true;
                }
                if (javaContainerConstraint.isNotEmpty() && (decomposableJavaContainer = this.decomposedContainerValueFactory.from(it)).getSize() == 0) {
                    throw new ContainerSizeFilterMissException("Container size is should not be 0.");
                }
                if (javaContainerConstraint.getMinSize() != null && (decomposableJavaContainer = this.decomposedContainerValueFactory.from(it)).getSize() < javaContainerConstraint.getMinSize()) {
                    throw new ContainerSizeFilterMissException("Container size is should not be less than " + javaContainerConstraint.getMinSize());
                }
                if (javaContainerConstraint.getMaxSize() != null && (decomposableJavaContainer = this.decomposedContainerValueFactory.from(it)).getSize() > javaContainerConstraint.getMaxSize()) {
                    throw new ContainerSizeFilterMissException("Container size is should not be greater than " + javaContainerConstraint.getMaxSize());
                }
                return true;
            });
        }
        return generated;
    }

    private LocalDate toLocalDate(Object value) {
        if (value instanceof Year) {
            return ((Year)value).atMonthDay(MonthDay.of(1, 1));
        }
        if (value instanceof YearMonth) {
            return ((YearMonth)value).atDay(1);
        }
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof MonthDay) {
            return Year.now().atMonthDay((MonthDay)value);
        }
        throw new IllegalArgumentException("Given type is not convertible to LocalDate. " + value.getClass());
    }

    private LocalDateTime toLocalDateTime(Object value) {
        if (Calendar.class.isAssignableFrom(value.getClass())) {
            return LocalDateTime.ofInstant(((Calendar)value).toInstant(), ZoneId.systemDefault());
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            return LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault());
        }
        if (Instant.class.isAssignableFrom(value.getClass())) {
            return LocalDateTime.ofInstant((Instant)value, ZoneId.systemDefault());
        }
        if (LocalDateTime.class.isAssignableFrom(value.getClass())) {
            return (LocalDateTime)value;
        }
        if (ZonedDateTime.class.isAssignableFrom(value.getClass())) {
            return ((ZonedDateTime)value).toLocalDateTime();
        }
        if (OffsetDateTime.class.isAssignableFrom(value.getClass())) {
            return ((OffsetDateTime)value).toLocalDateTime();
        }
        throw new IllegalArgumentException("Given type is not convertible to LocalDateTime. " + value.getClass());
    }

    private OffsetTime toOffsetTime(Object value) {
        if (value instanceof LocalTime) {
            return OffsetTime.of((LocalTime)value, ZONE_OFFSET);
        }
        if (value instanceof OffsetTime) {
            return (OffsetTime)value;
        }
        throw new IllegalArgumentException("Given type is not convertible to OffsetTime. " + value.getClass());
    }

    private BigDecimal toBigDecimal(Object value) {
        if (value instanceof Float || value instanceof Double) {
            return new BigDecimal(value.toString());
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        throw new IllegalArgumentException("Given type is not convertible to BigDecimal. " + value.getClass());
    }

    private BigInteger toBigInteger(Object value) {
        if (value instanceof Long || value instanceof Short || value instanceof Byte || value instanceof Integer) {
            return new BigInteger(value.toString());
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        throw new IllegalArgumentException("Given type is not convertible to BigInteger. " + value.getClass());
    }

    private boolean isBlank(String value) {
        char[] charArray = value.toCharArray();
        int length = 0;
        for (char c : charArray) {
            if (!Character.isWhitespace(c)) continue;
            ++length;
        }
        return value.length() == length;
    }
}

